import {
    Component,
    ContentChild,
    EventEmitter,
    Inject,
    Input,
    Output,
    TemplateRef,
    ViewEncapsulation
} from '@angular/core';
import { MAT_DIALOG_DATA, MatDialog, MatDialogRef } from '@angular/material/dialog';
import { DialogService } from '@bref/core';
import { Subscription } from 'rxjs';
import { FullscreenDialogService } from '../../services/fullscreen-dialog.service';
import { ConfirmCloseDialogComponent } from '../confirm-close-dialog/confirm-close-dialog.component';

@Component({
    selector: 'bre-dialog-fullscreen',
    templateUrl: './fullscreen-dialog.component.html',
    styleUrls: ['./fullscreen-dialog.component.scss'],
    encapsulation: ViewEncapsulation.None
})
export class FullscreenDialogComponent {
    subscription: Subscription;
    progress: number = 0;
    division: number;

    @Input() showCloseButton: boolean;
    @Input() hideBackButton: boolean;
    @Input() pagesCount: number;
    @Input() headerText: string;
    @Input() footerText: string;
    @Input() progressbar_headers: string[];
    @Input() isDialogFullScreen = false;
    @Input() showProgressBar = true;
    @Output() onPageChange = new EventEmitter<number>();

    @ContentChild(TemplateRef) dialogTemplate;
    enterdetails: boolean = false;
    context: {
        $implicit: any,
        close: (dialogResult?: any) => void,
        currentPage: number,
        nextPage: () => void,
        previousPage: () => void,
        redirectPage: (currentPageNum: number) => void
    };

    constructor(
        dialogRef: MatDialogRef<FullscreenDialogComponent>, 
        private matDialog: MatDialog, 
        @Inject(MAT_DIALOG_DATA) data, 
        private dialogData: FullscreenDialogService,
        private dialog: DialogService
    ) {
        this.context = {
            $implicit: data,
            close: dialogRef.close.bind(dialogRef),
            currentPage: 1,
            nextPage: () => {
                if (this.context.currentPage < this.pagesCount) {
                    this.context.currentPage++;
                    this.progress = this.context.currentPage - 1;
                    this.onPageChange.emit(this.context.currentPage);
                }
            },
            previousPage: () => {
                this.enterdetails = false;
                if (this.context.currentPage > 1) {
                    this.context.currentPage--;
                    this.progress = this.context.currentPage - 1;
                    if (this.context.currentPage == 1) {
                        this.enterdetails = true;
                    }
                    this.onPageChange.emit(this.context.currentPage);
                } else if (this.context.currentPage == 1 && this.enterdetails == false) {
                    this.matDialog.closeAll();
                }
            },
            redirectPage: (currentPageNum) => {
                if (this.context.currentPage <= this.pagesCount && this.context.currentPage > 1) {
                    this.context.currentPage = currentPageNum;
                    this.onPageChange.emit(this.context.currentPage);
                }
            }
        };
    }

    ngOnInit() {
        this.progress = 0;
        this.subscription = this.dialogData.currentPageNum.subscribe(currentPageNum => {
            this.context.redirectPage(currentPageNum);

        })
    }

    openConfirmremovedialog() {
        this.matDialog.open(ConfirmCloseDialogComponent);
    }
}
