import { async, ComponentFixture, TestBed } from '@angular/core/testing';

import { FullscreenDialogComponent } from './fullscreen-dialog.component';
import { CoreModule } from '@bref/core';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';

const mockMatDialogRef = { close: jest.fn() };

describe('FullscreenDialogComponent', () => {
  let component: FullscreenDialogComponent;
  let fixture: ComponentFixture<FullscreenDialogComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ FullscreenDialogComponent ],
      imports: [CoreModule],
      providers: [
        { provide: MAT_DIALOG_DATA, useValue: [] },
        { provide: MatDialogRef, useValue: mockMatDialogRef },
      ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(FullscreenDialogComponent);
    component = fixture.componentInstance;
    component.progressbar_headers = ['1', '2'];
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });
});
