import { Component, OnInit , Inject, Input } from '@angular/core';
import {MAT_DIALOG_DATA,MatDialog,MatDialogRef} from '@angular/material/dialog';
import { ToastService } from '@bref/core';
import { SelectedDeviceDataService } from "../../services/selected-device-data.service";
import { ApiService } from '@bref/core';
import { BulkOnboardingDevicesService } from '../../services/bulk-onboarding-service';
import {DevicesToStores} from '../../interfaces/devices-to-stores.interface';
import { AddStoreSource } from '../../interfaces/device-onboarding-api.interface';
import * as actionTypes from '../../constants/action-types-device-onboarding';
@Component({
  selector: 'bre-confirm-onboarding-popup',
  templateUrl: './confirm-onboarding-popup.component.html',
  styleUrls: ['./confirm-onboarding-popup.component.scss']
})
export class ConfirmOnboardingPopupComponent implements OnInit {
  @Input() checkBoxName:string = "Name";
  @Input() agreed:boolean = true;
  @Input() totalStores: any = 0;
  @Input() totDevices: any = 0;
  public installerObj: any = {};
  public stores: any = [];
  public payloadData: any = [];
  showLoader: boolean;
  deviceActionTypes: Object;
  constructor(private bulkOnboard: BulkOnboardingDevicesService , public dialogRef: MatDialogRef<ConfirmOnboardingPopupComponent> ,  @Inject(MAT_DIALOG_DATA) public data: AddStoreSource,private matDialog:MatDialog,private toast: ToastService,private selectedDeviceService: SelectedDeviceDataService,private api: ApiService) { }

  ngOnInit() {
    this.deviceActionTypes = actionTypes?.DEFAULT_ACTIONS;
    this.installerObj = this.bulkOnboard.getInstallerDetails();
    this.selectedDeviceService.getAddStoreObject().subscribe(data => {
      this.stores = data;
      this.totalStores = data.length;
      let totalDevices: number = 0;
          data.map(store => {
            totalDevices+=store.properties.length;
            this.generatePayload(store);
      });
      this.totDevices = totalDevices;
  }); 
 
    
  }

  /**
   * Generate storepayload
   * @param store
   */
  public generatePayload(store){
    let devicesObj = [];
    let addedStoresData = []
    store.properties.map(device =>{      
      /*Warranty time set to 23:59 */
      let wDate = device?.warranty;
      if(wDate){
        wDate.setHours(23);
        wDate.setSeconds(59);
        wDate.setMinutes(59);
        wDate.setMilliseconds(1);
      }     
      let deviceAbbreviation = device?.abbreviation?device?.abbreviation:'';
      let deviceName = device?.dName?.toLowerCase();
      let deviceDet = {
      
        "workflow": device?.deviceFlag,
        "deviceName": (device?.vendor + "-" + device?.modelNo + "-" + device?.sNo).replace(/ /g,''),
        "displayName": device?.dName + "-"  +  device.dLane + '-' + device.dAngle ,
        "identificationName": store.store.split('-')[0].trim() + store.store.split('-')[2].trim() + deviceAbbreviation +  device.unitNo ,
        "vendorId": parseInt(device?.vendor.split(" - ")[0]),
        "deviceFlag": device?.deviceFlag === "iot"?true:false,
        "modelNumber": device?.modelNo,
        "serialNumber": device?.sNo,
        "warranty": wDate?new Date(wDate)?.toISOString():"",   
        "installDate": device?.install?.toISOString(),
        "action": this.deviceActionTypes[deviceName]?this.deviceActionTypes[deviceName]:'' ,
        "reportedVersion": device?.firmware,
        "hardwareVersion": device?.hardware,
        "devicePropItems": {
          "laneNumber": device?.lane,            
          "macAddress": device?.mac,            
          "ipAddress": device?.ip            
          }
      }
      devicesObj.push(deviceDet);
    })

    let storeObj = {
      "restaurantId": parseInt(store.store.split(' - ')[1]),
      "installerName": this.installerObj.installerName,
      "deviceDetailsList": devicesObj,
      "installerEmail": this.installerObj.installerEmail
    }

    this.payloadData.push(storeObj);
  }

  
  /**
   * Send the selected devices and stores to BE on user confirmation.
   */
  onBoardDevice(){
    this.showLoader = true;
    let payload:DevicesToStores[] = this.payloadData;  
    this.bulkOnboard.onBoardDevices(payload).then((data) => {
      this.toast.success('Onboarding  successfully initiated. \r\n It may take several minutes for the device(s) to show up in the devices list.');
      this.showLoader=false;
      this.matDialog.closeAll();
    }).catch(error => {
      this.toast.error('Onboarding initiation failed.');
      this.showLoader = false;
      this.dialogRef.close();
    });
  
  }

  /**
   * Cancel button click.
   */
  cancelBoarding(){
    this.dialogRef.close()
  }

  /**
   * Enable or disable Onboarding button based on user agree.
   */
  setButtonState(){
    this.agreed = !this.agreed;       
  }
}
