import { async, ComponentFixture, TestBed } from "@angular/core/testing";
import { CoreModule, DialogService } from "@bref/core";
import { ConfirmOnboardingPopupComponent } from "./confirm-onboarding-popup.component";
import { RestaurantsApiService } from "../../services/restaurants-api.service";
import { SelectedDeviceDataService } from "../../services/selected-device-data.service";
import { BulkOnboardingDevicesService } from "../../services/bulk-onboarding-service";
import { SolutionsEnvService } from "../../solutions-env.service";
import { MatDialogRef, MAT_DIALOG_DATA } from "@angular/material/dialog";
import { MatCheckboxModule } from "@angular/material/checkbox";

xdescribe("ConfirmOnboardingPopupComponent", () => {
  let component: ConfirmOnboardingPopupComponent;
  let fixture: ComponentFixture<ConfirmOnboardingPopupComponent>;
  const mockMatDialogRef = { close: jest.fn() };
  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ConfirmOnboardingPopupComponent],
      imports: [CoreModule, MatCheckboxModule],
      providers: [
        SolutionsEnvService,
        BulkOnboardingDevicesService,
        RestaurantsApiService,
        SelectedDeviceDataService,
        DialogService,
        { provide: MAT_DIALOG_DATA, useValue: [] },
        { provide: MatDialogRef, useValue: mockMatDialogRef },
      ],
    }).compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(ConfirmOnboardingPopupComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it("should create", () => {
    expect(component).toBeTruthy();
  });
});
