import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { Component } from '@angular/core';
import { ComponentStatusPillComponent } from './component-status-pill.component';
import { StatusPillComponent } from '@bref/core';

describe('ComponentStatusPillComponent', () => {
  let component: MockComponent;
  let fixture: ComponentFixture<MockComponent>;

  @Component({
    selector: 'bre-mock',
    template: `<bre-component-status-pill [component]="{ onboardingStatus: 'Onboarding Completed' }"></bre-component-status-pill>`
  })
  class MockComponent { }

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ComponentStatusPillComponent, StatusPillComponent, MockComponent]
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(MockComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should display Active green pill', () => {
    expect(fixture.nativeElement.querySelector('.green').innerHTML).toContain('Onboarding Completed');
  })
});
