import { Component, OnInit, Input } from '@angular/core';
import { Certificates } from '../../interfaces/certificates.interface';

@Component({
  selector: 'bre-certificate-status-pill',
  templateUrl: './certificate-status-pill.component.html'
})
export class CertificateStatusPillComponent {

  @Input() certificate: Certificates;

  statusToType = {
    active: {
      label: 'Active',
      type: 'green'
    },
    needsAttention: {
      label: 'Needs Attention',
      type: 'purple'
    },
    expired: {
      label: 'Expired',
      type: 'red'
    }
  };

}
