import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { Component } from '@angular/core';
import { CertificateStatusPillComponent } from './certificate-status-pill.component';
import { StatusPillComponent } from '@bref/core';


describe('CertificateStatusPillComponent', () => {
  let component: MockComponent;
  let fixture: ComponentFixture<MockComponent>;

  @Component({
    selector: 'bre-mock',
    template: `
      <bre-certificate-status-pill [certificate]="{ status: 'expired' }"></bre-certificate-status-pill>
      <bre-certificate-status-pill [certificate]="{ status: 'active' }"></bre-certificate-status-pill>
    `
  })
  class MockComponent { }

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ CertificateStatusPillComponent, StatusPillComponent, MockComponent ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(MockComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should display in progress red pill', () => {
    expect(fixture.nativeElement.querySelector('.red').innerHTML).toContain('Expired');
  })
  it('should display completed green pill', () => {
    expect(fixture.nativeElement.querySelector('.green').innerHTML).toContain('Active');
  })
});
