import { BrowserModule } from '@angular/platform-browser';
import { NoopAnimationsModule } from '@angular/platform-browser/animations';
import { APP_INITIALIZER, NgModule } from '@angular/core';
import {environment} from "../environments/environment";
import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';
import { SolutionsEnvService, StandaloneSolutionsComponentsModule } from 'projects/solutions/src/public-api';

@NgModule({
  declarations: [
    AppComponent
  ],
  imports: [
    BrowserModule,
    AppRoutingModule,
    NoopAnimationsModule,
    StandaloneSolutionsComponentsModule.forRoot(environment)
  ],
  providers: [{ 
    provide: APP_INITIALIZER, 
    useFactory: getAppConfig,
    deps: [ SolutionsEnvService ], 
    multi: true
  }],
  bootstrap: [AppComponent]
})
export class AppModule { }

export function getAppConfig() {
  const init = () => {
    SolutionsEnvService.set(environment);
  }
  return init;
}
