import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';


const routes: Routes = [
  {
    path: '',
    redirectTo: '/solutions',
    pathMatch: 'full'
  },
  {
    path: 'solutions',
    loadChildren: () =>
      import('../../../solutions/src/lib/solutions.module').then(module => module.SolutionsModule)
  }
];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule]
})
export class AppRoutingModule { }
