Docker
NPM
Opentest
Angular

Environment Variables
Set BASE_URL which sets the URL the tests will use to access the restaurant service:

export BASE_URL="http://host.docker.internal:4200"
For best practice add this line to your ~/.bash_profile
Note that this needs to be set for the Opentest actor process in the terminal window where the OpenTest actor is running, or set it globally in bash profile as mentioned above.

Start the UI
In the root directory install the modules
ng install @bref/menu
ng install @bref/solutions
ng install @bref/deploy
ng serve --disableHostCheck true
Note we use disableHostCheck as otherwise the Selenium docker container will not be able to interact with host machine.

Start Docker
Install Docker locally if it hasn't been already: https://www.docker.com/products/docker-desktop

Start the Selenium Server
docker run -d -p 4444:4444 --name selenium -v /dev/shm:/dev/shm selenium/standalone-chrome:3.141.59-zirconium
Note that the version can be changed to see the latest version supported check
https://hub.docker.com/r/selenium/standalone-chrome/tags
Not if it complains that this server already exsits run
docker rm selenium
And try the run command above again

Start Opentest
Install Opentest if it hasn't been already:

npm install opentest -g
From opentest/server run:

opentest server
This will start the opentest server. In a new terminal, navigate to /opentest/actors and run:

opentest actor actor
This will start one of the test actors which will watch for a test session to execute.

Create a Test Session
With the server and a test actor running, a test session can be started either by navigating to the UI (localhost:3000 by default) or via the command line:

opentest session create --server http://localhost:3000 --template "AllTests" --wait --out junit.xml
This will start a test session which will run the tests. The --template flag determines which set of tests are run. The --out flag indicates the file to save test results to. The output for the above command should look something like:

Started test session 1581376513
Session completion timeout is set to 7200 seconds
Waiting for the test session to complete...
Logs for the tests themselves will appear in the actor process. Once the tests complete, the test results file will appear in the current directory. Alternatively, the results can be queried from the server using the test session ID:

curl http://localhost:3000/api/session/1581376513?format=junit
TBD
Custom JAR files can be added to the user-jars directory within each actor directory (e.g. opentest/actors/actor1/user-jars). These JARs extend opentest functionality with additional custom keywords that can be called from within the tests.
