resource "aws_lambda_function" "rbac-lambda" {
    
    function_name    = "${upper(substr(var.region, 0, 7))}-${upper(var.environment)}-${var.tags["Name"]}"
    role             = aws_iam_role.lambda_role.arn
    handler          = "main.handler"
    
    runtime          = "python3.7"

    filename         = data.archive_file.lambda_zip.output_path
    source_code_hash = data.archive_file.lambda_zip.output_base64sha256
    tags             = var.tags

}

resource "aws_iam_role" "lambda_role" {
  name = "${upper(substr(var.region, 0, 7))}-${upper(var.environment)}-BRE-RBAC-LAMBDA-IAM-ROLE"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "lambda.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "AWSLambdaBasicExecutionRole" {
  role       = aws_iam_role.lambda_role.name
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSLambdaBasicExecutionRole"
}


