import json
import unittest
from unittest.mock import patch
from main import handler, read_yaml 

example_jwt = (
    b"eyJhbGciOiAiSFMyNTYiLCAidHlwIjogIkpXVCJ9"
    b".eyJoZWxsbyI6ICJ3b3JsZCJ9"
    b".aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
)

yaml_file = "src/resources/rbac_roles_mapping.yaml"

class TestConnection(unittest.TestCase):
    def test_call_handle(self):
        event = {
            'headers': {'Authorization': 'Bearer eyJhbGciOiAiSFMyNTYiLCAidHlwIjogIkpXVCJ9.eyJoZWxsbyI6ICJ3b3JsZCJ9.tvagLDLoaiJKxOKqpBXSEGy7SYSifZhjntgm9ctpyj8'}
        }
        response = handler(event, {})
        response_body = json.loads(response["body"])
        assert response["statusCode"] == 200
        assert response_body["data"]["uiModules"][0] == "bre_menu"

    def test_call_handle_with_invalid_token(self):
        event = {
            'headers': {'Authorization': 'Bearer abcd'}
        }
        response = handler(event, {})
        response_body = json.loads(response["body"])
        assert response_body["error"][0] == "Something went wrong."
        assert response["statusCode"] == 400
    
    def test_call_read_yaml(self):
        with patch("jwt.decode") as decode_mock:
            decode_mock.return_value = {
                'group': ["APP1359676_BreT_Admin"]
            }
            response = read_yaml(example_jwt, yaml_file)
            assert len(response) == 5

    def test_call_read_yaml_one_role(self):
        with patch("jwt.decode") as decode_mock:
            decode_mock.return_value = {
                'group': ["APP1359676_BreT_User_Configure"]
            }
            response = read_yaml(example_jwt, yaml_file)
            assert len(response) == 2

    def test_call_invalid_read_yaml(self):
        response = read_yaml(example_jwt, yaml_file)
        assert len(response) == 1