import { Injectable } from '@angular/core';
import { Router, Route, CanLoad } from '@angular/router';
import { AuthorizationService } from './authorization.service';
import { RBACService, ToastService } from "@bref/core";
@Injectable()
export class AuthGuardService implements CanLoad {
    loader = false;
    constructor(private authorizationService: AuthorizationService, private router: Router, private rbac: RBACService,
        private toastService: ToastService) {
    }

    /**
     * 
     * @param route route of the current requested page
     * This function is called on ever route change or page load. This returns true or false if the modules is present in
     * in access modules response or not.
     * @returns boolean
     */
    canLoad(route: Route) {
        const accessToken = this.authorizationService.getAccessToken();
        if (this.authorizationService?.hasFetchedAuthorizedComponents) {
            return this.isRouteAllowed(route);
        }
        else {
            this.loader = true;
            return this.authorizationService.fetchAuthorizedComponents(accessToken).then(response => {
                this.loader = false;
                return this.isRouteAllowed(route);
            });
        }
    }

    /**
     * 
     * @param state of each route
     * This functions test if the requested modules is present in accessible modules if so returns true else shows a toast message and
     * returns false.
     * @returns boolean
     */
    isRouteAllowed(state) {
        let currentActiveUrl = state.path;
        currentActiveUrl = currentActiveUrl === 'configure' ? 'config' : currentActiveUrl;
        let isAuthorisedComponent = this.authorizationService.authorizedComponents?.filter(item => item.indexOf(currentActiveUrl) > -1 && item.indexOf('button') == -1);
        if (isAuthorisedComponent?.length > 0) {
            return true;
        } else {
            localStorage.setItem("error403Message", '');
            this.router.navigate(["403"]);
        }
    }
}