import { Injectable } from "@angular/core";
import { ConfigureEnvService } from "@bref/configure";
import { DeployEnvService } from "@bref/deploy";
import { SolutionsEnvService } from "@bref/solutions";
import { MenuEnvService } from "@bref/menu";
import { StoresEnvService } from "@bref/stores";
import { CoreEnvService } from "@bref/core";
import { AuthorizationService } from "./authorization.service";

declare global {
  interface Window {
    appConfig: any;
  }
}

@Injectable({
  providedIn: "root",
})
export class AppEnvService {
  public static env = window.appConfig;

  constructor(private authorizationService: AuthorizationService) {}

  setTokenInModules() {
    const token = this.authorizationService.getAccessToken();
    if (token) {
      // Setup token for configure module
      ConfigureEnvService.setToken(token);

      // Setup token for deploy module
      DeployEnvService.setToken(token);

      // Setup token for solutions module
      SolutionsEnvService.setToken(token);

      // Setup token for menu module
      MenuEnvService.setToken(token);

      StoresEnvService.setToken(token);

      CoreEnvService.setToken(token);
    }
  }

  public setEnv() {
    // Setup env for configure module
    ConfigureEnvService.set(AppEnvService.env);

    // Setup env for deploy module
    DeployEnvService.set(AppEnvService.env);

    // Setup env for solutions module
    SolutionsEnvService.set(AppEnvService.env);

    // Setup env for menu module
    MenuEnvService.set(AppEnvService.env);

    StoresEnvService.set(AppEnvService.env);

    CoreEnvService.set(AppEnvService.env);

    this.setTokenInModules();

    delete window.appConfig;
  }

  public getUrl(name) {
    return AppEnvService.env[name];
  }
}
