import { Component, OnInit, ViewEncapsulation } from '@angular/core';
import { dependencies } from '../../../../package.json';

@Component({
  selector: 'bre-main-dashboard',
  templateUrl: './dashboard.component.html',
  styleUrls: ['./dashboard.component.scss'],
  encapsulation: ViewEncapsulation.None
})
export class DashboardComponent implements OnInit {
  showVersions = false;
  coreVersion: string;
  menuVersion: string;
  solutionsVersion: string;
  deployVersion: string;
  configureVersion: string;

  ngOnInit(): void {
    this.coreVersion = dependencies['@bref/core'].replace(/\^/g, '');
    this.menuVersion = dependencies['@bref/menu'].replace(/\^/g, '');
    this.solutionsVersion = dependencies['@bref/solutions'].replace(/\^/g, '');
    this.deployVersion = dependencies['@bref/deploy'].replace(/\^/g, '');
    this.configureVersion = dependencies['@bref/configure'].replace(/\^/g, '');
  }

  goToNews() {
    window.location.href = 'https://news.mcdonalds.com/';
  }

  toggleVersionInfoPanel() {
    this.showVersions = !this.showVersions;
  }
}
