import { ComponentFixture, TestBed } from "@angular/core/testing";
import { RouterTestingModule } from "@angular/router/testing";
import { CoreModule } from "@bref/core";
import { DashboardComponent } from './dashboard.component';

describe('DashboardComponent', () => {
    let component: DashboardComponent;
    let fixture: ComponentFixture<DashboardComponent>;
  
    beforeEach(() => {
      TestBed.configureTestingModule({
        declarations: [DashboardComponent],
        imports: [RouterTestingModule, CoreModule]
      })
        .compileComponents();
    });
  
    beforeEach(() => {
      fixture = TestBed.createComponent(DashboardComponent);
      component = fixture.componentInstance;
      fixture.detectChanges();
    });
  
    it('should create', () => {
      expect(component).toBeTruthy();
    });

    it('should direct the user to McDonald\'s News upon button click', () => {
        spyOn(component, 'goToNews');
        
        const newsButton = fixture.nativeElement.querySelector('.news-button-container button.news-button');
        newsButton.click();
        fixture.detectChanges();

        expect(component.goToNews).toHaveBeenCalled();
    });
});