import { Component, OnInit, ViewEncapsulation } from "@angular/core";
import { ApiService } from "@bref/core";
import { AppEnvService } from "src/app/services/app-env.service";
import { AuthorizationService } from "src/app/services/authorization.service";

@Component({
  selector: "bre-access-required",
  templateUrl: "./access-required.component.html",
  styleUrls: ["./access-required.component.scss"],
  encapsulation: ViewEncapsulation.None,
})
export class AccessRequiredComponent implements OnInit {
  error403Message: any;
  error403MessageDetail: string;
  error403RequestedStatus: boolean;
  private BACKEND_BASE_HEADERS = { Authorization: "" };
  private readonly baseUrl;
  private MSAL_ID_TOKEN: string;
  showBtn: boolean = true;
  constructor(
    private apiService: ApiService,
    private appEnvService: AppEnvService,
    private authorizationService: AuthorizationService
  ) {
    this.baseUrl = this.appEnvService.getUrl("menuServiceBaseUrl");
    this.MSAL_ID_TOKEN = this.authorizationService.getAccessToken();
    this.BACKEND_BASE_HEADERS.Authorization = "Bearer " + this.MSAL_ID_TOKEN;
  }

  ngOnInit(): void {
    this.error403MessageDetail = localStorage.getItem("error403MessageDetail");
    this.error403Message = localStorage.getItem("error403Message");
    this.error403RequestedStatus = !!localStorage.getItem(
      "error403RequestedStatus"
    );
    this.requestStatusChange();
  }

  goToHomePage() {
    window.location.href = "/";
  }

  async requestAccess() {
    await this.apiService
      .get<any>(
        `${this.baseUrl}/user/register`,
        null,
        null,
        this.BACKEND_BASE_HEADERS
      )
      .then((reqResponse) => {
        this.error403RequestedStatus = true;
        this.requestStatusChange();
      });
  }

  requestStatusChange() {
    if (this.error403RequestedStatus) {
      this.showBtn = false;
      this.error403Message = `You will be notified via email once an admin approves your access to Menu Services.`;
      localStorage.setItem("error403MessageDetail", "");
      localStorage.setItem("error403RequestedStatus", "true");
    }
  }
}
