import { ComponentFixture, TestBed } from "@angular/core/testing";
import { RouterTestingModule } from "@angular/router/testing";
import { ApiService, CoreModule } from "@bref/core";
import { AccessRequiredComponent } from "./access-required.component";
import { AppEnvService } from "src/app/services/app-env.service";
import { AuthorizationService } from "src/app/services/authorization.service";
jest.useFakeTimers();

const env = {
  menuServiceBaseUrl: "https://menu.ui-api.dev.bre.mcd.com",
};

class AppEnvServiceMock {
  getUrl(name) {
    return env[name];
  }
}

describe("AccessRequiredComponent", () => {
  let component: AccessRequiredComponent;
  let fixture: ComponentFixture<AccessRequiredComponent>;

  beforeEach(() => {
    TestBed.configureTestingModule({
      declarations: [AccessRequiredComponent],
      imports: [RouterTestingModule, CoreModule],
      providers: [
        ApiService,
        AuthorizationService,
        { provide: "env", useValue: env },
        { provide: AppEnvService, useValue: new AppEnvServiceMock() },
      ],
    }).compileComponents();
  });

  beforeEach(() => {
    fixture = TestBed.createComponent(AccessRequiredComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it("should create", () => {
    expect(component).toBeTruthy();
  });
});
