import { Component, OnInit } from "@angular/core";
import { MsalService } from "@azure/msal-angular";
import { AuthorizationService } from "../services/authorization.service";

@Component({
  selector: "bre-navigation-menu",
  templateUrl: "./navigation-menu.component.html",
  styleUrls: ["./navigation-menu.component.scss"]
})
export class NavigationMenuComponent implements OnInit {
  isFranchisee: boolean = true;
  env: string;

  constructor(
    private authService: MsalService,
    private authorizationService: AuthorizationService
  ) {}

  ngOnInit(): void {
    this.env = this.authorizationService.getEnvName();
  }

  logout() {
    localStorage.removeItem("access_token");
    this.authService.logout();
  }
}