import { async, ComponentFixture, TestBed } from "@angular/core/testing";
import { RouterTestingModule } from "@angular/router/testing";
import { Router, NavigationEnd } from "@angular/router";
import { MsalService } from "@azure/msal-angular";
import { NavigationMenuComponent } from "./navigation-menu.component";
import { StandaloneDeployComponentsModule } from "@bref/deploy";
import { StandaloneSolutionsComponentsModule } from "@bref/solutions";
import { StandaloneMenuComponentsModule } from "@bref/menu";
import { StandaloneConfigureComponentsModule } from "@bref/configure";
import { LogoutNavButtonComponent } from "../components/logout-nav-button/logout-nav-button.component";
import { CoreModule, RBACService } from "@bref/core";
import { StandaloneStoresComponentsModule } from "@bref/stores";
import { AuthorizationService } from "../services/authorization.service";
import { Account } from "msal";

const mockGetAccount = jest.fn(() => {
  return {
    id: "",
    displayName: "",
    rpDisplayName: "",
    accountIdentifier: "",
    userName: "",
    idToken: null,
    idTokenClaims: null,
    homeAccountIdentifier: "",
    name: "",
    sid: "",
    environment: ""
  };
});

class MsalServiceMock {
  getAccount(): Account {
    return mockGetAccount();
  }
}

class MockAuthorizationService {
  getUserGroups() {
    return [];
  }
  getEnvName() {
    return "";
  }
}

const rbacService = new RBACService();
rbacService.setAuthorizedComponents([
  "bre_menu",
  "bre_deploy",
  "bre_solutions",
  "bre_config"
]);

describe("NavigationMenuComponent", () => {
  let fixture: ComponentFixture<NavigationMenuComponent>;
  let component: NavigationMenuComponent;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [
        RouterTestingModule,
        StandaloneDeployComponentsModule,
        StandaloneSolutionsComponentsModule,
        StandaloneMenuComponentsModule,
        StandaloneConfigureComponentsModule,
        StandaloneStoresComponentsModule,
        CoreModule
      ],
      declarations: [NavigationMenuComponent, LogoutNavButtonComponent],
      providers: [
        { provide: MsalService, useValue: new MsalServiceMock() },
        {
          provide: AuthorizationService,
          useValue: new MockAuthorizationService()
        },
        { provide: RBACService, useValue: rbacService }
      ]
    }).compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(NavigationMenuComponent);
    fixture.autoDetectChanges();
    component = fixture.componentInstance;
  });

  it("should create", () => {
    expect(component).toBeTruthy();
  });
});