import { Component, OnInit } from '@angular/core';
import { AuthorizationService } from "../services/authorization.service";
@Component({
  selector: 'bre-header',
  templateUrl: './header.component.html',
  styleUrls: ['./header.component.scss']
})
export class HeaderComponent implements OnInit {
  public market: string;
  public env: string;
  constructor(private authorizationService: AuthorizationService) {
    // market will eventually be set by API call/user input in dropdown,
    // set to 'us' as a default since we're only supporting US markets for now
    this.market = 'us';
  }
  ngOnInit(): void {
    this.env = this.authorizationService.getEnvName();
  }
}
