import { async, ComponentFixture, TestBed } from '@angular/core/testing';

import { HeaderComponent } from './header.component';
import { AuthorizationService } from "../services/authorization.service";
import { StatusPillComponent} from '@bref/core';

class MockAuthorizationService {
  getEnvName() {
    return "";
  }
}

describe('HeaderComponent', () => {
  let component: HeaderComponent;
  let fixture: ComponentFixture<HeaderComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ HeaderComponent , StatusPillComponent ],
      providers: [       
        {
          provide: AuthorizationService,
          useValue: new MockAuthorizationService()
        }
      ]
    })
    .compileComponents();
  }));

  
  beforeEach(() => {
    fixture = TestBed.createComponent(HeaderComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should render title', () => {
    const compiled = fixture.nativeElement;
    const header = compiled.querySelector('div ul .header-label')
    expect(header.textContent).toContain('BRE Technology Platform')
  });

  it('should display a MCD logo that links to the home page', () => {
    const compiled = fixture.nativeElement;
    const logo = compiled.querySelector('.bre-header-container .header-logo a');
    expect(logo.getAttribute('routerLink')).toEqual('/');
  });

  it('should display the current market', () => {
    component.market = 'test';
    fixture.detectChanges();
    const compiled = fixture.nativeElement;
    const marketDisplay = compiled.querySelector('.bre-header-container .header-market .market-name');
    expect(marketDisplay.textContent).toBe('TEST Market');
  });
});
