/**
 * This file is required for ADFS metadata.
 * Metadata receieved from https://gas.mcd.com/adfs/.well-known/openid-configuration has to be saved because ADFS 2016 do not support CORS.
 */

const authorityMetadata =
  `{"issuer":"https://gas.mcd.com/adfs",
  "authorization_endpoint":"https://gas.mcd.com/adfs/oauth2/authorize/",
  "token_endpoint":"https://gas.mcd.com/adfs/oauth2/token/",
  "jwks_uri":"https://gas.mcd.com/adfs/discovery/keys",
  "token_endpoint_auth_methods_supported":["client_secret_post","client_secret_basic","private_key_jwt","windows_client_authentication"],
  "response_types_supported":["code","id_token","code id_token","id_token token","code token","code id_token token"],
  "response_modes_supported":["query","fragment","form_post"],
  "grant_types_supported":["authorization_code","refresh_token","client_credentials",
  "urn:ietf:params:oauth:grant-type:jwt-bearer","implicit","password","srv_challenge",
  "urn:ietf:params:oauth:grant-type:device_code","device_code"],
  "subject_types_supported":["pairwise"],
  "scopes_supported":["user_impersonation","openid","aza","profile","logon_cert","vpn_cert","winhello_cert","allatclaims","email"],
  "id_token_signing_alg_values_supported":["RS256"],
  "token_endpoint_auth_signing_alg_values_supported":["RS256"],
  "access_token_issuer":"http://gas.mcd.com/adfs/services/trust",
  "claims_supported":["aud","iss","iat","exp","auth_time","nonce","at_hash","c_hash","sub","upn","unique_name","pwd_url",
  "pwd_exp","mfa_auth_time","sid"],
  "microsoft_multi_refresh_token":true,"userinfo_endpoint":"https://gas.mcd.com/adfs/userinfo",
  "capabilities":[],
  "end_session_endpoint":"https://gas.mcd.com/adfs/oauth2/logout",
  "as_access_token_token_binding_supported":true,
  "as_refresh_token_token_binding_supported":true,
  "resource_access_token_token_binding_supported":true,
  "op_id_token_token_binding_supported":true,
  "rp_id_token_token_binding_supported":true,
  "frontchannel_logout_supported":true,
  "frontchannel_logout_session_supported":true,
  "device_authorization_endpoint":"https://gas.mcd.com/adfs/oauth2/devicecode"}`;
export default authorityMetadata;
