import { BrowserModule } from "@angular/platform-browser";
import { NgModule, APP_INITIALIZER } from "@angular/core";
import { MsalModule, MsalInterceptor } from "@azure/msal-angular";
import { NoopAnimationsModule } from "@angular/platform-browser/animations";
import {
  ConfigureModule,
  StandaloneConfigureComponentsModule
} from "@bref/configure";
import { DeployModule, StandaloneDeployComponentsModule } from "@bref/deploy";
import { MenuModule, StandaloneMenuComponentsModule } from "@bref/menu";
import {
  SolutionsModule,
  StandaloneSolutionsComponentsModule
} from "@bref/solutions";
import { StoresModule, StandaloneStoresComponentsModule } from "@bref/stores";
import { AppComponent } from "./app.component";
import { RouterModule } from "@angular/router";
import { NavigationMenuComponent } from "./navigation-menu/navigation-menu.component";
import { HeaderComponent } from "./header/header.component";
import { HTTP_INTERCEPTORS } from "@angular/common/http";
import { DashboardComponent } from "./pages/dashboard/dashboard.component";
import { AccessRequiredComponent } from "./pages/access-required/access-required.component";
import { environment } from "src/environments/environment";
import { CoreModule, NavButtonComponent } from "@bref/core";
import { LogoutNavButtonComponent } from "./components/logout-nav-button/logout-nav-button.component";
import { AppEnvService } from "./services/app-env.service";
import authorityMetadata from "./authorityMetadata";
import { AuthGuardService } from './services/auth-guard.service';
@NgModule({
  declarations: [
    AppComponent,
    HeaderComponent,
    NavigationMenuComponent,
    DashboardComponent,
    AccessRequiredComponent,
    LogoutNavButtonComponent
  ],
  imports: [
    BrowserModule,
    NoopAnimationsModule,
    CoreModule,
    StandaloneStoresComponentsModule.forRoot(environment),
    StandaloneDeployComponentsModule.forRoot(environment),
    StandaloneSolutionsComponentsModule.forRoot(environment),
    StandaloneMenuComponentsModule.forRoot(environment),
    StandaloneConfigureComponentsModule.forRoot(environment),
    RouterModule.forRoot(
      [
        {
          path: "",
          component: DashboardComponent,
          pathMatch: "full"
        },
        {
          path: "403",
          component: AccessRequiredComponent,
          pathMatch: "full"
        },{
          path: "restaurants",
          data: { breadcrumb: "BRE Stores" },
          loadChildren: () => StoresModule
        },
        {
          path: "menu",
          data: { breadcrumb: "BRE Menu" },
          canLoad : [AuthGuardService],
          loadChildren: () => MenuModule
        },
        {
          path: "solutions",
          data: {},
          loadChildren: () => SolutionsModule,
          canLoad : [AuthGuardService]
        },
        {
          path: "support",
          canLoad: [AuthGuardService],
          data: { breadcrumb: "BRE Support" },
          children: []
        },
        {
          path: "deploy",
          data: {},
          loadChildren: () => DeployModule,
          canLoad: [AuthGuardService],
        },
        {
          path: "configure",
          data: {},
          canLoad : [AuthGuardService],
          loadChildren: () => ConfigureModule
        },
        { path: "**", redirectTo: "" }
      ],
      { initialNavigation: "enabled" }
    ),
    MsalModule.forRoot(
      {
        auth: {
          clientId: AppEnvService.env.auth.clientId,
          authority: AppEnvService.env.auth.authority,
          validateAuthority: true,
          knownAuthorities: AppEnvService.env.auth.knownAuthorities,
          redirectUri: AppEnvService.env.auth.redirectUri,
          postLogoutRedirectUri: AppEnvService.env.auth.redirectUri,
          navigateToLoginRequestUrl: true,
          authorityMetadata: authorityMetadata
        },
        cache: {
          cacheLocation: "localStorage",
          storeAuthStateInCookie: false
        }
      },
      {
        popUp: false,
        consentScopes: ["user.read", "openid", "profile"],
        unprotectedResources: [],
        protectedResourceMap: [
          ["https://graph.microsoft.com/v1.0/me", ["user.read"]]
        ],
        extraQueryParameters: {}
      }
    )
  ],
  providers: [
    {
      provide: APP_INITIALIZER,
      useFactory: getAppConfig,
      deps: [AppEnvService],
      multi: true
    },
    {
      provide: HTTP_INTERCEPTORS,
      useClass: MsalInterceptor,
      multi: true
    },
    AuthGuardService
  ],
  bootstrap: [AppComponent]
})
export class AppModule {}

export function getAppConfig(appEnvService: AppEnvService) {
  const init = () => {
    appEnvService.setEnv();
  };
  return init;
}