# Pipeline Breakdown

**Container Builder Pipeline**

* Uses our `build-tools` container to build a Dockerfile and push it to ECR/Artifactory
* Docker image is first built and tagged with the registry/application name
* The pipeline checks release and replace version tags for the image. If the image is not properly tagged, the pipeline will error to ensure versioning standards are kept.
* Before pushing the docker image to the registry the pipeline will check the type of branch the dockerfile is coming from `(master, feature, hotfix)` and tag the image accordingly. Tagging will be skipped if branch type is does not match any of the types allowed. [for hotfix and feature branches jira ticket numbers will be included in the tag as well]
* Once pushed to the Docker image registry, the unneeded images are removed.
* Pipeline checks if this build is a release build or a master/feature/hotfix build. Depending on the build type the pipeline will send a new release message or a regular build message to the respective topic.


# Pipeline Guide

**Confluence**: https://us-confluence.mcd.com/pages/viewpage.action?pageId=140347235

# Development Guidelines

**Confluence**: https://us-confluence.mcd.com/pages/viewpage.action?spaceKey=BREP&title=Development+Guidelines
