import { APP_INITIALIZER, NgModule } from '@angular/core';
import { RouterModule } from '@angular/router';
import { SandboxComponent } from './sandbox.component';
import { BrowserModule } from '@angular/platform-browser';
import { NoopAnimationsModule } from '@angular/platform-browser/animations';
import { environment } from '../environments/environment';
import { CoreEnvService } from 'projects/core/src/public-api';
import { HeaderComponent } from "../../../core/src/lib/components/header/header.component";
import { NavigationPanelComponent } from "../../../core/src/lib/components/navigation-panel/navigation-panel.component";

@NgModule({
    declarations: [
        SandboxComponent,
        HeaderComponent,
        NavigationPanelComponent
    ],
    imports: [
        BrowserModule,
        NoopAnimationsModule,
        RouterModule.forRoot([
            {
                path: '',
                redirectTo: 'sandbox',
                pathMatch: 'full'
            },
            {
                path: 'sandbox',
                data: { breadcrumb: 'Sandbox' },
                loadChildren: () =>
                    import('./app.module').then(module => module.AppModule)
            }
        ])
    ],
    providers: [{ 
        provide: APP_INITIALIZER, 
        useFactory: getAppConfig,
        deps: [ CoreEnvService ], 
        multi: true
      }],
    exports: [RouterModule],
    bootstrap: [SandboxComponent]
})
export class SandboxModule { }

export function getAppConfig() {
    const init = () => {
      CoreEnvService.set(environment);
    }
    return init;
  }