import { NgModule } from "@angular/core";

import {
  AppComponent,
  SinglePageDialog,
  MultiPageDialog,
  FullScreenDialog,
} from "./app.component";
import { CoreModule } from "projects/core/src/public-api";
import { RouterModule } from "@angular/router";
import { FormsModule } from "@angular/forms";
import { BasicElementsPageComponent } from "projects/core/src/lib/components/basic-elements-page/basic-elements-page.component";
import { FiltersPageComponent } from "projects/core/src/lib/components/filters-page/filters-page.component"
import { CalendarPageComponent } from "projects/core/src/lib/components/calendar-page/calendar-page.component"
import { ButtonsPageComponent } from "projects/core/src/lib/components/buttons-page/buttons-page.component";
import { NavigationTabsComponent } from "projects/core/src/lib/components/navigation-tabs/navigation-tabs.component";
import { CoreComponentsComponent } from "projects/core/src/lib/components/core-components/core-components.component";
import {
  PopupsPageComponent, SinglePageDialogTem,
  MultiPageDialogTem,
  FullScreenDialogTem
} from "projects/core/src/lib/components/popups-page/popups-page.component";
import { SectionComponentComponent } from "projects/core/src/lib/components/section-component/section-component.component";

@NgModule({
  declarations: [
    PopupsPageComponent,
    AppComponent,
    SinglePageDialog,
    MultiPageDialog,
    FullScreenDialog,
    BasicElementsPageComponent,
    FiltersPageComponent,
    CalendarPageComponent,
    ButtonsPageComponent,
    NavigationTabsComponent,
    CoreComponentsComponent,
    SinglePageDialogTem,
    MultiPageDialogTem,
    FullScreenDialogTem,
    SectionComponentComponent
  ],
  imports: [
    CoreModule,
    FormsModule,
    RouterModule.forChild([
      {
        path: "",
        pathMatch: "full",
        redirectTo: "app",
      },
      {
        path: "app",
        pathMatch: "prefix",
        component: AppComponent,
        data: {
          breadcrumb: "App",
        },
      },
      {
        path: "table-filters",
        pathMatch: "table-filters",
        component: FiltersPageComponent,
      },
      {
        path: "navigation-tabs",
        pathMatch: "navigation-tabs",
        component: NavigationTabsComponent
      },
      {
        path: "components",
        pathMatch: "components",
        component: CoreComponentsComponent
      },
      {
        path: "pop-ups",
        pathMatch: "pop-ups",
        component: PopupsPageComponent
      },
      {
        path: "section-components",
        pathMatch: "section-components",
        component: SectionComponentComponent
      },
      {
        path: "nav/:id",
        pathMatch: "prefix",
        component: NavigationTabsComponent,
        data: {
          breadcrumb: "foo",
        },
        children: [
          {
            path: "bar",
            pathMatch: "prefix",
            component: NavigationTabsComponent,
            data: {
              breadcrumb: "bar",
            },
          },
        ],
      },
      {
        path: "foo/:id",
        pathMatch: "prefix",
        component: AppComponent,
        data: {
          breadcrumb: "foo",
        },
        children: [
          {
            path: "bar",
            pathMatch: "prefix",
            component: AppComponent,
            data: {
              breadcrumb: "bar",
            },
          },
        ],
      },
      {
        path: "submenu",
        pathMatch: "prefix",
        component: AppComponent,
        data: {
          breadcrumb: "Sub Menu",
        },
      },
      {
        path: "submenu/calendar",
        pathMatch: "prefix",
        component: CalendarPageComponent,
        data: {
          breadcrumb: "calendar",
        },
      }, {
        path: "submenu/buttons",
        pathMatch: "prefix",
        component: ButtonsPageComponent,
        data: {
          breadcrumb: "buttons",
        },
      },
    ]),
  ],
  providers: []
})
export class AppModule { }
