import { Component } from "@angular/core";
import { Router, ActivatedRoute } from "@angular/router";
import {
  DialogService,
  ToastService,
  FilterType,
  PageSizes,
  TableSortDirection,
  FiltersChangeEvent,
  NavSubMenu,
  DefaultKeyFilters,
  QuickJumpViewLoadDataEvent,
  TableEditOption,
} from "projects/core/src/public-api";
import { FormBuilder, Validators } from "@angular/forms";
import { isNgContent } from "@angular/compiler";
import { FullscreenDialogComponent } from "projects/core/src/lib/components/fullscreen-dialog/fullscreen-dialog.component";
import { TimeFilters } from "projects/core/src/lib/components/filter-table-update/filter-table-update.component";
import { MatDialog } from "@angular/material/dialog";

@Component({
  selector: "app",
  templateUrl: "./app.component.html",
  styles: ["hr { margin: 40px 0; }"],
})
export class AppComponent {
  accordionMenu = {
    items: [
      {
        value: "1",
        label: "Item 1",
        children: [
          { label: "Item 1a", value: "1a" },
          {
            label: "Item 1b",
            value: "1b",
            children: [
              { label: "Item 1ba", value: "1ba" },
              {
                label: "Item 1bb",
                value: "1bb",
                children: [{ label: "Item 1bba", value: "1bba" }],
              },
            ],
          },
          { label: "Item 1c", value: "1b" },
        ],
      },
      {
        value: "2",
        label: "Item 2",
      },
    ],
    onClick: (event) => {
      this.toastService.success(`Item ${event} clicked!`);
    },
  };
  selectedOption: string;

  autoComplete = {
    options: [],
    selectedOptions: [],
    loadOptions: (query: string) => {
      this.autoComplete.options = [
        { label: "Item 1", value: "1" },
        { label: "Item 2", value: "2" },
      ].filter((x) => x.label.toLowerCase().includes(query.toLowerCase()));
    },
  };

  breadcrumbs = {
    items: [
      { label: "Manual Sandbox", url: "/sandbox" },
      { label: "Manual Foo", url: "/sandbox/foo" },
      { label: "Manual Foo 1", url: "/sandbox/foo/1" },
    ],
  };

  calendar = {
    singleValue: null,
    rangeValue: null,
    effectiveDateValue: null,
    currentSelected: null,
    minDate: null,
    calendarSelected: (event) => {
      this.calendar.currentSelected = "Effective Date";
    },
    singleValueChange: (event) => console.log("calendar single value", event),
    rangeValueChange: (event) => console.log("calendar range value", event),
    effectiveDateChange: (event) =>
      console.log("calendar effective Date change", event),
    _init: () => {
      const today = new Date();
      const afterTomorrow = new Date();
      afterTomorrow.setDate(today.getDate() + 2);
      this.calendar.singleValue = afterTomorrow;
      this.calendar.rangeValue = [today, afterTomorrow];
      this.calendar.effectiveDateValue = new Date();
      this.calendar.minDate = new Date();
    },
    reset: () => {
      this.calendar.effectiveDateValue = this.calendar.minDate;
    },
  };

  monthCalendar = {
    dateformat: null,
    monthValue: null,
    monthValueChange: (event) => {
      console.log("calendar month value", event);
      const month = new Date(event);
      this.monthCalendar.monthValue = month;
    },
    _init: () => {
      const today = new Date();
      this.monthCalendar.monthValue = today;
    },
  };

  dropdown = {
    items: [
      { label: "Item 1", value: "1" },
      { label: "Item 2", value: "2" },
    ],
    value: "2",
    initialValue: "2",
  };

  largeDropdown = {
    items: [
      { label: "Item 1", value: "1" },
      { label: "Item 2", value: "2" },
      { label: "Item 3", value: "3" },
      { label: "Item 4", value: "4" },
      { label: "Item 5", value: "5" },
      { label: "Item 6", value: "6" },
      { label: "Item 7", value: "7" },
      { label: "Item 8", value: "8" },
      { label: "Item 9", value: "9" },
      { label: "Item 10", value: "10" },
      { label: "Item 11", value: "11" },
      { label: "Item 12", value: "12" },
      { label: "Item 13", value: "13" },
      { label: "Item 14", value: "14" },
    ],
    value: "2",
    initialValue: "2",
  };
  languageOptions = {
    items: [
      { label: "EN - US", value: "EN" },
      { label: "ES - US", value: "ES" },
    ],
  };

  searchableDropdown = {
    items: [
      { label: "n/a", value: null },
      { label: "Item 1", value: "1" },
      { label: "Item 2", value: "2" },
    ],
    value: null,
  };

  dropdownError = {
    items: [
      { label: "Item 1", value: "1" },
      { label: "Item 2", value: "2" },
    ],
    value: "",
    initialValue: "",
    hasError: (value) => !value,
  };

  searchable = {
    items: [
      { label: "Item 1", value: "1" },
      { label: "Item 2", value: "2" },
    ],
    value: "1",
    initialValue: "1",
    parentFormChanged: ($event) => {
      this.searchable.value = $event.value;
    },
  };

  lazyLoadedSearchable = {
    items: [
      { label: "Item 1", value: "1" },
      { label: "Item 2", value: "2" },
      { label: "Item 3", value: "3" },
      { label: "Item 4", value: "4" },
      { label: "Item 5", value: "5" },
      { label: "Item 6", value: "6" },
      { label: "Item 7", value: "7" },
      { label: "Item 8", value: "8" },
      { label: "Item 9", value: "9" },
      { label: "Item 10", value: "10" },
      { label: "Item 11", value: "11" },
      { label: "Item 12", value: "12" },
      { label: "Item 13", value: "13" },
      { label: "Item 14", value: "14" },
      { label: "Item 15", value: "15" },
      { label: "Item 16", value: "16" },
      { label: "Item 17", value: "17" },
      { label: "Item 18", value: "18" },
      { label: "Item 19", value: "19" },
      { label: "Item 20", value: "20" },
      { label: "Item 21", value: "21" },
      { label: "Item 22", value: "22" },
      { label: "Item 23", value: "23" },
      { label: "Item 24", value: "24" },
      { label: "Item 25", value: "25" },
      { label: "Item 26", value: "26" },
      { label: "Item 27", value: "27" },
      { label: "Item 28", value: "28" },
      { label: "Item 29", value: "29" },
      { label: "Item 30", value: "30" },
      { label: "Item 31", value: "31" },
      { label: "Item 32", value: "33" },
      { label: "Item 33", value: "33" },
      { label: "Item 34", value: "34" },
      { label: "Item 35", value: "35" },
      { label: "Item 36", value: "36" },
      { label: "Item 37", value: "37" },
      { label: "Item 38", value: "38" },
      { label: "Item 39", value: "39" },
      { label: "Item 40", value: "40" },
      { label: "Item 41", value: "41" },
      { label: "Item 42", value: "42" },
      { label: "Item 43", value: "43" },
      { label: "Item 44", value: "44" },
      { label: "Item 45", value: "45" },
      { label: "Item 46", value: "46" },
      { label: "Item 47", value: "47" },
      { label: "Item 48", value: "48" },
      { label: "Item 49", value: "49" },
      { label: "Item 50", value: "50" },
      { label: "Item 51", value: "51" },
      { label: "Item 52", value: "52" },
      { label: "Item 53", value: "53" },
      { label: "Item 54", value: "54" },
      { label: "Item 55", value: "55" },
      { label: "Item 56", value: "56" },
      { label: "Item 57", value: "57" },
      { label: "Item 58", value: "58" },
      { label: "Item 59", value: "59" },
      { label: "Item 60", value: "60" },
      { label: "Item 61", value: "61" },
      { label: "Item 62", value: "62" },
      { label: "Item 63", value: "63" },
      { label: "Item 64", value: "64" },
      { label: "Item 65", value: "65" },
      { label: "Item 66", value: "66" },
      { label: "Item 67", value: "67" },
      { label: "Item 68", value: "68" },
      { label: "Item 69", value: "69" },
      { label: "Item 70", value: "70" },
      { label: "Item 71", value: "71" },
      { label: "Item 72", value: "72" },
      { label: "Item 73", value: "73" },
      { label: "Item 74", value: "74" },
      { label: "Item 75", value: "75" },
      { label: "Item 76", value: "76" },
      { label: "Item 77", value: "77" },
      { label: "Item 78", value: "78" },
      { label: "Item 79", value: "79" },
      { label: "Item 80", value: "80" },
      { label: "Item 81", value: "81" },
      { label: "Item 82", value: "82" },
      { label: "Item 83", value: "83" },
      { label: "Item 84", value: "84" },
      { label: "Item 85", value: "85" },
      { label: "Item 86", value: "86" },
      { label: "Item 87", value: "87" },
      { label: "Item 88", value: "88" },
      { label: "Item 89", value: "89" },
      { label: "Item 90", value: "90" },
      { label: "Item 91", value: "91" },
      { label: "Item 92", value: "92" },
      { label: "Item 93", value: "93" },
      { label: "Item 94", value: "94" },
      { label: "Item 95", value: "95" },
      { label: "Item 96", value: "96" },
      { label: "Item 97", value: "97" },
      { label: "Item 98", value: "98" },
      { label: "Item 99", value: "99" },
      { label: "Item 100", value: "100" },
      { label: "Item 101", value: "101" },
      { label: "Item 102", value: "102" },
      { label: "Item 103", value: "104" },
      { label: "Item 104", value: "104" },
      { label: "Item 105", value: "105" },
      { label: "Item 106", value: "106" },
      { label: "Item 107", value: "107" },
      { label: "Item 108", value: "108" },
      { label: "Item 109", value: "109" },
      { label: "Item 110", value: "110" },
      { label: "Item 111", value: "111" },
      { label: "Item 112", value: "112" },
      { label: "Item 113", value: "113" },
      { label: "Item 114", value: "114" },
      { label: "Item 115", value: "115" },
      { label: "Item 116", value: "116" },
      { label: "Item 117", value: "117" },
      { label: "Item 118", value: "118" },
      { label: "Item 119", value: "119" },
      { label: "Item 120", value: "120" },
      { label: "Item 121", value: "121" },
      { label: "Item 122", value: "122" },
      { label: "Item 123", value: "123" },
      { label: "Item 124", value: "124" },
      { label: "Item 125", value: "125" },
      { label: "Item 126", value: "126" },
      { label: "Item 127", value: "127" },
      { label: "Item 128", value: "128" },
      { label: "Item 129", value: "129" },
      { label: "Item 130", value: "130" },
      { label: "Item 131", value: "131" },
      { label: "Item 132", value: "132" },
      { label: "Item 133", value: "133" },
      { label: "Item 134", value: "134" },
      { label: "Item 135", value: "135" },
      { label: "Item 136", value: "136" },
      { label: "Item 137", value: "137" },
      { label: "Item 138", value: "138" },
      { label: "Item 139", value: "139" },
      { label: "Item 140", value: "140" },
    ],
    value: "1",
    initialValue: "1",
    parentFormChanged: ($event) => {
      this.lazyLoadedSearchable.value = $event.value;
    },
  };

  searchableError = {
    items: [
      { label: "Item 1", value: "1" },
      { label: "Item 2", value: "2" },
    ],
    value: "",
    initialValue: "",
    hasError: (value) => !value,
    parentFormChanged: ($event) => {
      this.searchable.value = $event.value;
    },
  };

  filterGroup = {
    filters: [
      {
        name: "autocomplete",
        type: FilterType.autocomplete,
        placeholder: "Start typing Item1",
        options: [{ label: "Item 1", value: "1" }],
        loadOptions: (query) => {
          this.filterGroup.filters[0].options = [
            ...this.filterGroup.filters[0].options,
            ...[
              { label: "Item 1", value: "1" },
              { label: "Item 2", value: "2" },
            ].filter((x) =>
              x.label.toLowerCase().includes(query.toLowerCase())
            ),
          ].reduce((options, item) => {
            if (!options.some((x) => x.value === item.value)) {
              options.push(item);
            }
            return options;
          }, []);
        },
        isAdvanced: false,
      },
      {
        name: "multiselect",
        type: FilterType.multiselect,
        placeholder: "Multi-Select",
        options: [
          { label: "Item 1", value: 1 },
          { label: "Item 2", value: "2" },
        ],
        isAdvanced: false,
      },
      {
        name: "dropdown",
        type: FilterType.dropdown,
        placeholder: "",
        options: [
          { label: "Item 1", value: "1" },
          { label: "Item 2", value: "2" },
        ],
        isAdvanced: false,
        initialValue: "1",
      },
      {
        name: "calendar",
        type: FilterType.calendar,
        placeholder: "Calendar",
        isAdvanced: false,
      },
      {
        name: "profileName",
        type: FilterType.input,
        placeholder: "Search by Profile Name",
        isAdvanced: false,
        canClearItems: true,
      },
    ],
    selectedFilters: {
      autocomplete: "1",
      multiselect: [1],
      calendar: [new Date()],
    },
    handleChange: ($event: FiltersChangeEvent) => {
      this.filterGroup.selectedFilters = { ...$event.filters };
    },
  };

  popover = {
    toast: {
      menuItems: [
        {
          label: "Item 1",
          action: () => this.toastService.success("Item 1 selected"),
        },
        {
          label: "Item 2",
          action: () => this.toastService.success("Item 2 selected"),
        },
      ],
    },
    valueChange: {
      value: 0,
      menuItems: [
        {
          label: "Item 1",
          action: () => {
            this.popover.valueChange.value = 1;
          },
        },
        {
          label: "Item 2",
          action: () => {
            this.popover.valueChange.value = 2;
          },
        },
        {
          label: "Item 3",
          action: () => {
            this.popover.valueChange.value = 3;
          },
        },
      ],
    },
    dropdown: {
      menuItems: [
        {
          label: "Add New Option",
          action: () => {
            const newValue = this.dropdown.items.length + 1;
            this.dropdown.items.push({
              label: `Item ${newValue}`,
              value: newValue.toString(),
            });
          },
        },
      ],
    },
    multiSelect: {
      menuItems: [
        {
          label: "Add New Option",
          action: () => {
            const newValue = this.multiSelect.items.length + 1;
            this.multiSelect.items.push({
              label: `Item ${newValue}`,
              value: newValue,
            });
          },
        },
      ],
    },
    searchable: {
      menuItems: [
        {
          label: "Add New Option",
          action: () => {
            const newValue = this.searchable.items.length + 1;
            this.searchable.items.push({
              label: `Item ${newValue}`,
              value: newValue.toString(),
            });
          },
        },
      ],
    },
  };

  form = {
    formGroup: null,
    reset: () => {
      this.form.formGroup.enable();
      this.form.formGroup.reset();
    },
    value: "123",
    disable: () => this.form.formGroup.disable(),
    stringify: () => JSON.stringify(this.form.formGroup.value),
    onFocusOut: true,
    _init: () => {
      this.form.formGroup = this.fb.group({
        dropdown: "2",
        input: "form input",
        multiSelect: { value: [2, 3], disabled: false },
        searchableSelect: ["2", Validators.required],
        initialValue: "2",
        toggleSwitch: true,
      });
      this.form.formGroup?.valueChanges.subscribe((changes) => {
        this.form.formGroup.value = { ...changes };
      });
    },
    inputChanged: (event) => {
      this.form.value = event.value;
    },
    inputfocusedout: (event) => {
      this.form.value = event.value;
    },
    parentFormChanged: ($event) => {
      if ("isPristine" in $event) {
        $event.isPristine
          ? this.form.formGroup.get($event.controlName).markAsPristine()
          : this.form.formGroup.get($event.controlName).markAsDirty();
      }
      this.form.formGroup.controls[$event.controlName].setValue($event.value);
    },
  };

  input = {
    exampleRegex: DefaultKeyFilters.num,
    value: "saf fds",
  };

  inputError = {
    exampleRegex: DefaultKeyFilters.num,
    value: "",
    hasError: (value) => !value,
  };

  iconButton = {
    handleClick: (event) => console.log("icon button clicked!"),
  };

  searchableSelect = {
    currentSelected: "Market Selected",
    hierarchyAttributes: {
      "Market Selected": false,
      "Market Unselected": false,
      "Market Disabled": true,
    },
    handleClick: (event) => {
      if (!this.searchableSelect.hierarchyAttributes[event]) {
        this.searchableSelect.currentSelected = event;
      }
    },
    items: [
      { label: "Item 1", value: "1" },
      { label: "Item 2", value: "2" },
    ],
    valueSelected: "1",
    valueUnselected: "1",
    valueDisabled: "1",
    initialValue: "1",
    shouldReset: false,
    valueSelectedChanged: (event) => {
      this.searchableSelect.valueSelected = event.value;
    },
    valueUnselectedChanged: (event) => {
      this.searchableSelect.valueUnselected = event.value;
    },
    valueDisabledChanged: (event) => {
      this.searchableSelect.valueDisabled = event.value;
    },
    changeValues: () => {
      this.searchableSelect.valueUnselected = "2";
    },
    resetSelect: () => {
      this.searchableSelect.shouldReset = true;
      this.searchableSelect.valueSelected = "1";
      this.searchableSelect.valueUnselected = "1";
      this.searchableSelect.valueDisabled = "1";
    },
    resetForm: (event) => {
      this.searchableSelect.shouldReset = false;
    },
  };

  categoryDropdown = {
    items: [
      {
        label:
          '<span class="category-level">Food > </span><span class="category-level">Dessert</span>',
        value: "1",
      },
      {
        label:
          '<span class="category-level">Food > </span><span class="category-level">Entree</span>',
        value: "2",
      },
    ],
    value: "1",
    initialValue: "1",
    parentFormChanged: ($event) => {
      this.categoryDropdown.value = $event.value;
    },
  };

  multiSelect = {
    items: [
      { label: "Item 1", value: 1 },
      { label: "Item 2", value: 2 },
      { label: "Item 3", value: 3 },
    ],
    selectedItems: [1, 2],
    initialValue: [1, 2],
  };

  multiSelectError = {
    items: [
      { label: "Item 1", value: 1 },
      { label: "Item 2", value: 2 },
      { label: "Item 3", value: 3 },
    ],
    selectedItems: "",
    initialValue: [],
    hasError: (value) => !value,
  };

  navigationBar = {
    items: [
      { label: "App", url: "/sandbox/app", isActive: false },
      { label: "Foo", url: "/sandbox/foo/1", isActive: false },
      { label: "Bar", url: "/sandbox/foo/1/bar", isActive: false },
    ],
    sort: (arr, sortColumn, ascOrDsc) => {
      arr.sort((a, b) => {
        if (a[sortColumn] > b[sortColumn] && ascOrDsc === "asc") {
          return 1;
        } else {
          return -1;
        }
      });
      return arr;
    },
    sortColumn: (sortItem) => {
      this.tableNonPaginated.items = [
        ...this.tableNonPaginated.sort(
          sortItem.data,
          sortItem.sortBy,
          sortItem.sortDirection
        ),
      ];
    },
    _init: () => {
      this.route.url.subscribe(() => {
        this.navigationBar.items.forEach((x) => {
          x.isActive = x.url === this.router.url.split("?")[0];
        });
      });
    },
  };

  navSubmenus: NavSubMenu[] = [
    { label: "Submenu 1", url: "/sandbox/submenu/1" },
    { label: "Submenu 2", url: "/sandbox/submenu/2" },
    { label: "Disabled Submenu", url: "/sandbox/submenu/3", disabled: true },
  ];

  quickJump = {
    data: [],
    total: 20,
    loadMore: (event: QuickJumpViewLoadDataEvent) => {
      this.quickJump.loading = true;
      setTimeout(() => {
        for (let i = event.start; i < event.end; i++) {
          this.quickJump.data.push({ label: `Item ${i}` });
        }
        this.quickJump.loading = false;
      }, 250);
    },
    loading: true,
  };

  paginatedTable = {
    items: [],
    itemCount: 20,
    page: undefined,
    pageSize: undefined,
    sortBy: "value",
    sortDirection: TableSortDirection.asc,
    pageChange: (event) => {
      // console.log('page change event', event);
      this.paginatedTable.items = [
        ...this.paginatedTable.sort(
          event.data,
          event.sortBy,
          event.sortDirection
        ),
      ];
    },
    sort: (arr, sortColumn, ascOrDsc) => {
      arr.sort((a, b) => {
        if (a[sortColumn] > b[sortColumn] && ascOrDsc === "asc") {
          return 1;
        } else {
          return -1;
        }
      });
      return arr;
    },
    sortColumn: (sortItem) => {
      // console.log(sortItem.sortDirection);
      this.paginatedTable.items = [
        ...this.paginatedTable.sort(
          sortItem.data,
          sortItem.sortBy,
          sortItem.sortDirection
        ),
      ];
    },
    selectedChange: (event) => {
      // console.log('selection change event', event)
    },
    updateItemCount: (itemCount) => {
      this.paginatedTable.itemCount = parseInt(itemCount, 10);
    },
    _init: () => {
      this.paginatedTable.page = 2;
      this.paginatedTable.pageSize = PageSizes.TwentyFive;
      setTimeout(() => {
        this.paginatedTable.items = [
          { label: "Item 1", value: "1" },
          { label: "Item 3", value: "3" },
          { label: "Item 2", value: "2" },
          { label: "Item 4", value: "3" },
          { label: "Item 5", value: "5" },
          { label: "Item 6", value: "6" },
          { label: "Item 1", value: "1" },
          { label: "Item 3", value: "3" },
          { label: "Item 2", value: "2" },
          { label: "Item 4", value: "3" },
          { label: "Item 5", value: "5" },
          { label: "Item 6", value: "6" },
          { label: "Item 1", value: "1" },
          { label: "Item 3", value: "3" },
          { label: "Item 2", value: "2" },
          { label: "Item 4", value: "3" },
          { label: "Item 5", value: "5" },
          { label: "Item 6", value: "6" },
          { label: "Item 1", value: "1" },
          { label: "Item 3", value: "3" },
          { label: "Item 2", value: "2" },
          { label: "Item 4", value: "3" },
          { label: "Item 5", value: "5" },
          { label: "Item 6", value: "6" },
          { label: "Item 1", value: "1" },
          { label: "Item 3", value: "3" },
          { label: "Item 2", value: "2" },
          { label: "Item 4", value: "3" },
          { label: "Item 5", value: "5" },
          { label: "Item 6", value: "6" },
          { label: "Item 1", value: "1" },
          { label: "Item 3", value: "3" },
          { label: "Item 2", value: "2" },
          { label: "Item 4", value: "3" },
          { label: "Item 5", value: "5" },
          {
            label: "Item 6",
            value:
              "test test test test test test test test test test test test test test test test test test test test test test test test ",
          },
        ];
        this.paginatedTable.itemCount = 179;
      }, 1000);
    },
  };

  paginatedTableWithFilters = {
    items: [
      {
        label: "Item 1",
        value: "1",
        name: "test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 ",
        date: "2022-12-01 00:56:20 ",
      },
      {
        label: "Item 3",
        value: "3",
        name: "test2",
        date: "1999-02-02 22:59:55 ",
      },
      {
        label: "Item 2",
        value: "2",
        name: "test3",
        date: "2020-10-08 22:59:55 ",
      },
      {
        label: "Item 4",
        value: "3",
        name: "test4",
        date: "1987-10-06 22:59:55 ",
      },
      {
        label: "Item 5",
        value: "5",
        name: "test5",
        date: "2022-02-08 22:59:55 ",
      },
      {
        label: "Item 6",
        value: "6",
        name: "test6",
        date: "2022-02-08 21:59:55 ",
      },
    ],
    itemCount: 6,
    page: 1,
    pageSize: 25,
    sortBy: "value",
    sortDirection: TableSortDirection.asc,
    pageChange: (event) => {
      // console.log('page change event', event);
      this.paginatedTableWithFilters.items = [
        ...this.paginatedTableWithFilters.sort(
          event.data,
          event.sortBy,
          event.sortDirection
        ),
      ];
    },
    sort: (arr, sortColumn, ascOrDsc) => {
      arr.sort((a, b) => {
        if (sortColumn === "date") {
          a = new Date(a[sortColumn]);
          b = new Date(b[sortColumn]);
          if (ascOrDsc === "asc") return a - b;
          else {
            return b - a;
          }
        }
        if (a[sortColumn] > b[sortColumn] && ascOrDsc === "asc") {
          return 1;
        } else {
          return -1;
        }
      });
      return arr;
    },
    sortColumn: (sortItem) => {
      // console.log(sortItem.sortDirection);
      this.paginatedTableWithFilters.items = [
        ...this.paginatedTableWithFilters.sort(
          sortItem.data,
          sortItem.sortBy,
          sortItem.sortDirection
        ),
      ];
    },

    selectedChange: (event) => {
      // console.log('selection change event', event)
    },
    updateItemCount: (itemCount) => {
      this.paginatedTableWithFilters.itemCount = parseInt(itemCount, 10);
    },
    confirmInputValue: (event) => {
      //  console.log('input entered and apply button clicked', event);
    },
  };
  filterUpdateItems = [
    {
      label: "Item 1",
      value: "1",
      status: "In-progress",
      date: "1987-10-08 22:59:55 ",
    },
    {
      label: "Item 2",
      value: "2",
      status: "In-progress",
      date: "1999-02-02 22:59:55 ",
    },
    {
      label: "Item 3",
      value: "3",
      status: "In-progress",
      date: "2020-10-08 22:59:55 ",
    },
    {
      label: "Item 4",
      value: "3",
      status: "Completed",
      date: "1987-10-06 22:59:55 ",
    },
    {
      label: "Item 5",
      value: "5",
      status: "Completed",
      date: "2022-02-08 22:59:55 ",
    },
    {
      label: "Item 6",
      value: "6",
      status: "Completed",
      date: "2022-02-08 21:59:55 ",
    },
    {
      label: "Item 1",
      value: "1",
      status: "Completed",
      date: "1987-10-08 22:59:55 ",
    },
    {
      label: "Item 3",
      value: "3",
      status: "Failed",
      date: "1999-02-02 22:59:55 ",
    },
    {
      label: "Item 2",
      value: "2",
      status: "Failed",
      date: "2020-10-08 22:59:55 ",
    },
    {
      label: "Item 4",
      value: "3",
      status: "Failed",
      date: "1987-10-06 22:59:55 ",
    },
    {
      label: "Item 5",
      value: "5",
      status: "Completed",
      date: "2022-02-08 22:59:55 ",
    },
    {
      label: "Item 6",
      value: "6",
      status: "Failed",
      date: "2022-02-08 21:59:55 ",
    },
    {
      label: "Item 1",
      value: "1",
      status: "Failed",
      date: "1987-10-08 22:59:55 ",
    },
    {
      label: "Item 3",
      value: "3",
      status: "Completed",
      date: "1999-02-02 22:59:55 ",
    },
    {
      label: "Item 2",
      value: "2",
      status: "Completed",
      date: "2020-10-08 22:59:55 ",
    },
    {
      label: "Item 4",
      value: "3",
      status: "Completed",
      date: "1987-10-06 22:59:55 ",
    },
    {
      label: "Item 5",
      value: "5",
      status: "Completed",
      date: "2022-07-13 22:59:55 ",
    },
    {
      label: "Item 6",
      value: "6",
      status: "Completed",
      date: "2022-07-13 21:59:55 ",
    },
    {
      label: "Item 1",
      value: "1",
      status: "Failed",
      date: "1987-10-08 22:59:55 ",
    },
    {
      label: "Item 3",
      value: "3",
      status: "In-progress",
      date: "1999-02-02 22:59:55 ",
    },
    {
      label: "Item 2",
      value: "2",
      status: "Completed",
      date: "2020-10-08 22:59:55 ",
    },
    {
      label: "Item 4",
      value: "3",
      status: "Completed",
      date: "1987-10-06 22:59:55 ",
    },
    {
      label: "Item 5",
      value: "5",
      status: "Completed",
      date: "2022-02-08 22:59:55 ",
    },
    {
      label: "Item 6",
      value: "6",
      status: "Failed",
      date: "2022-02-08 21:59:55 ",
    },
  ];
  paginatedTableWithFiltersUpdate = {
    items: this.filterUpdateItems,
    itemCount: 100,
    page: 1,
    pageSize: 25,
    sortBy: "value",
    sortDirection: TableSortDirection.asc,
    showSearchAutoSuggestList: [],
    checkBoxList: [
      {
        label: "Failed",
        value: "Failed",
      },
      {
        label: "Completed",
        value: "Completed",
      },
      {
        label: "In-progress",
        value: "In-progress",
      },
      {
        label: "unknown",
        value: "unknown",
      },
    ],
    pageChange: (event) => {
      console.log("page change event", event);

      if (event.page === 2) {
        this.paginatedTableWithFiltersUpdate.items = [
          {
            label: "Item 1",
            value: "1",
            status: "In-progress",
            date: "1987-10-08 22:59:55 ",
          },
          {
            label: "Item 2",
            value: "2",
            status: "In-progress",
            date: "1999-02-02 22:59:55 ",
          },
        ];
      }
      this.paginatedTableWithFiltersUpdate.page = event.page;
    },
    sort: (arr, sortColumn, ascOrDsc) => {
      arr.sort((a, b) => {
        if (sortColumn === "date") {
          a = new Date(a[sortColumn]);
          b = new Date(b[sortColumn]);
          if (ascOrDsc === "asc") return a - b;
          else {
            return b - a;
          }
        }
        if (a[sortColumn] > b[sortColumn] && ascOrDsc === "asc") {
          return 1;
        } else {
          return -1;
        }
      });
      return arr;
    },
    sortColumn: (sortItem) => {
      console.log(sortItem.sortDirection);
    },
    initialPageSize: 25,

    selectedChange: (event) => {
      console.log("selection change event", event);
    },
    confirmInputValue: (event) => {
      console.log(event);
      event.map((item) => {
        switch (item.type) {
          case "autoSuggest": {
            if (item?.items && item?.items?.length) {
              this.paginatedTableWithFiltersUpdate.items =
                this.paginatedTableWithFiltersUpdate.items.filter((val) => {
                  if (item?.items.includes(val.label)) {
                    return val;
                  }
                });
            } else {
              this.paginatedTableWithFiltersUpdate.items =
                this.filterUpdateItems;
            }
            break;
          }
          case "sortDirection": {
            this.sortTableByColumn(
              event.columnName,
              event.items,
              this.paginatedTableWithFiltersUpdate.items
            );
            break;
          }
          case "timeFilters": {
            this.paginatedTableWithFiltersUpdate.items =
              this.applyDateTimeFilters(
                event.items,
                event.columnName,
                this.paginatedTableWithFiltersUpdate.items
              );
            break;
          }
          case "checkboxFilters": {
            console.log("checkboxFilters", event);
          }
        }
      });
    },
    onInputChange: (event) => {
      if (event.query) {
        this.paginatedTableWithFiltersUpdate.showSearchAutoSuggestList =
          this.paginatedTableWithFiltersUpdate.items
            .filter((item) => item.label.indexOf(event.query) > 0)
            .map((item) => item.label);
      } else {
        this.paginatedTableWithFiltersUpdate.items = this.filterUpdateItems;
      }
    },
    fitlersCleared: () => {
      this.paginatedTableWithFiltersUpdate.items = this.filterUpdateItems;
    },
  };
  showStores: boolean = false;

  sortTableByColumn(column, direction: TableSortDirection, data) {
    return data.sort((a, b) => {
      let rowA =
        typeof a[column] === "string"
          ? a[column].toLowerCase().trim()
          : a[column];
      let rowB =
        typeof b[column] === "string"
          ? b[column].toLowerCase().trim()
          : b[column];
      if (!rowA) {
        rowA = "";
      }
      if (!rowB) {
        rowB = "";
      }
      let dateFlag: boolean = false;

      var dateReg = /^\d{2}([./-])\d{2}\1\d{4}$/;
      if (rowA.toString().match(dateReg) && rowB.toString().match(dateReg)) {
        dateFlag = true;
      } else {
        dateFlag = false;
      }
      return this.sortComparison(rowA, rowB, direction, dateFlag);
    });
  }

  private sortComparison(
    rowA,
    rowB,
    direction: TableSortDirection,
    dateFlag?: boolean
  ): number {
    if (TableSortDirection[direction] === TableSortDirection["asc"]) {
      if (dateFlag) {
        let date1 = new Date(rowA.toString());
        let date2 = new Date(rowB.toString());
        if (date1 < date2) return -1;
        if (date1 > date2) return 1;
        return 0;
      } else {
        if (rowA < rowB) return -1;
        if (rowA > rowB) return 1;
        return 0;
      }
    }
    if (TableSortDirection[direction] === TableSortDirection["desc"]) {
      if (dateFlag) {
        let date1 = new Date(rowA.toString());
        let date2 = new Date(rowB.toString());
        if (date1 > date2) return -1;
        if (date1 < date2) return 1;
        return 0;
      } else {
        if (rowA > rowB) return -1;
        if (rowA < rowB) return 1;
        return 0;
      }
    }
  }

  applyDateTimeFilters(timeFilters: TimeFilters, columnName: string, data) {
    let filteredData = data;
    const dateRange = timeFilters?.dateRange;
    const selectedHours = timeFilters?.selectedHours;

    filteredData = filteredData.filter((rowData) => {
      let match = true;
      let dateMatch = true;
      const regex = /(^\d{4}-\d{2}-\d{2})\s(\d{2})\:(\d{2})\:(\d{2})\s/;
      const regexResults = regex.exec(rowData[columnName]);
      if (dateRange) {
        const lowerBound = dateRange[0];
        const upperBound = dateRange[1];
        const rowDate = regexResults?.[1];
        if (upperBound) {
          match = this.checkIfDateInRange(lowerBound, upperBound, rowDate);
          dateMatch = match;
        } else {
          match = this.checkIfDatesAreEqual(lowerBound, rowDate);
          dateMatch = match;
        }
      }
      if (selectedHours) {
        match = this.checkIfTimeInRange(selectedHours, regexResults[2]);
      }
      return match && dateMatch;
    });
    return filteredData;
  }

  private checkIfDateInRange(
    lowerBound: string,
    upperBound: string,
    rowDate: string
  ): boolean {
    const rowDateObject = new Date(rowDate).setHours(0, 0, 0, 0);
    const lowerBoundDate = new Date(lowerBound).setHours(0, 0, 0, 0);
    const upperBoundDate = new Date(upperBound).setHours(0, 0, 0, 0);
    return rowDateObject >= lowerBoundDate && rowDateObject <= upperBoundDate;
  }

  private checkIfDatesAreEqual(lowerBound: string, rowDate: string): boolean {
    return lowerBound == rowDate;
  }

  private checkIfTimeInRange(selectedHours, hour) {
    return selectedHours.includes(hour.toString());
  }

  tableNonPaginated = {
    items: [
      { label: "Item 1", value: "1" },
      { label: "Item 2", value: "2" },
      { label: "Item 3", value: "4" },
      { label: "Item 4", value: "3" },
      { label: "Item 5", value: "4" },
    ],
    sortBy: "value",
    sortDirection: TableSortDirection.asc,
    itemCount: 5,
    pageChange: (event) => {
      // console.log('page change event', event);
    },
    selectedChange: (event) => {
      // console.log('selection change event', event)
    },

    sort: (arr, sortColumn, ascOrDsc) => {
      arr.sort((a, b) => {
        if (a[sortColumn] > b[sortColumn] && ascOrDsc === "asc") {
          return 1;
        } else {
          return -1;
        }
      });
      return arr;
    },
    sortColumn: (sortItem) => {
      // console.log(sortItem.sortDirection);
      this.tableNonPaginated.items = [
        ...this.tableNonPaginated.sort(
          this.tableNonPaginated.items,
          sortItem.sortBy,
          sortItem.sortDirection
        ),
      ];
    },
    _init: () => {
      setTimeout(() => {
        this.tableNonPaginated.items = [
          { label: "Item 1", value: "1" },
          { label: "Item 2", value: "2" },
        ];
      }, 1000);
    },
  };

  tableNonPaginatedWithFilters = {
    selectedColumn: "typeVal",
    filterLabel: "Filter by Value",
    itemCount: 5,
    items: [
      {
        label: "Item 1",
        value: "1",
        checkbox: "new",
        date: "1987-10-08 22:59:55 ",
        hiddenValue0: "hidden 0 0",
        hiddenValue1: "hidden 1 0",
        hiddenValue2: "hidden 2 0",
        typeVal: "check1",
      },
      {
        label: "Items 2",
        value: "2",
        checkbox: "old",
        date: "2020-10-08 22:59:55 ",
        hiddenValue0: null,
        hiddenValue1: null,
        hiddenValue2: "",
        typeVal: "check1",
      },
      {
        label: "Items 3",
        value: "4",
        checkbox: "new",
        date: "1987-10-06 22:59:55 ",
        hiddenValue0: null,
        hiddenValue1: null,
        hiddenValue2: "one hidden value",
        typeVal: "check2",
      },
      {
        label: "Items 4",
        value: "3",
        checkbox: "old",
        date: "2019-03-08 22:59:55 ",
        hiddenValue0: "hidden 0",
        hiddenValue1: "hidden 1",
        hiddenValue2: "hidden 2",
        typeVal: "check1",
      },
      {
        label: "Item 5",
        value: "4",
        checkbox: "new",
        date: "2020-05-19 22:59:55 ",
        hiddenValue0: null,
        hiddenValue1: null,
        hiddenValue2: null,
        typeVal: "check2",
      },
    ],
    sortBy: "value",
    sortDirection: TableSortDirection.asc,
    checkboxOptions: [
      { label: "fresh", value: "fresh" },
      { label: "old", value: "old" },
      { label: "new", value: "new" },
    ],
    pageChange: (event) => {
      // console.log('page change event', event);
    },
    selectedChange: (event) => {
      // console.log('selection change event', event)
    },
    updateConfirmed: (event) => {
      console.log("row update confirmed", event);
    },

    sort: (arr, sortColumn, ascOrDsc) => {
      arr.sort((a, b) => {
        if (sortColumn === "date") {
          a = new Date(a[sortColumn]);
          b = new Date(b[sortColumn]);
          if (ascOrDsc === "asc") return a - b;
          else {
            return b - a;
          }
        }
        if (a[sortColumn] > b[sortColumn] && ascOrDsc === "asc") {
          return 1;
        } else {
          return -1;
        }
      });
      return arr;
    },
    sortColumn: (sortItem) => {
      // console.log('sort item!:', sortItem);
      this.tableNonPaginatedWithFilters.items = [
        ...this.tableNonPaginatedWithFilters.sort(
          sortItem.data,
          sortItem.sortBy,
          sortItem.sortDirection
        ),
      ];
    },
  };

  tableNonPaginatedWithFiltersNoCrossIcon = {
    selectedColumn: "typeVal",
    filterLabel: "Filter by Value",
    itemCount: 5,
    items: [
      {
        label: "Item 1",
        value: "1",
        checkbox: "new",
        date: "1987-10-08 22:59:55 ",
        nodes: [
          [{"label": "hiddenValue0", "value" : "hidden 0 0"},
          {"label": "hiddenValue1", "value" : "hidden 0 0"},
          {"label": "hiddenValue2", "value" : "hidden 0 0"}],
          [
            {"label": "hiddenValue0", "value" : "hidden"},
            {"label": "hiddenValue2", "value" : "hidden2"},
            {"label": "hiddenValue1", "value" : "hiddendashdsahdkhsk"}
          ]        
        ],
        labels: ["hiddenValue0", "hiddenValue1", "hiddenValue1"],
        nodesLength: 2,
        typeVal: "check1",
      },
      {
        label: "Item 1",
        value: "1",
        checkbox: "new",
        date: "1987-10-08 22:59:55 ",
        nodes: [
          [{"label": "hiddenValue0", "value" : "hidden 0 0"},
          {"label": "hiddenValue1", "value" : "hidden 0 0"},
          {"label": "hiddenValue2", "value" : "hidden 0 0"}],
          [
            {"label": "hiddenValue0", "value" : "hidden"},
            {"label": "hiddenValue2", "value" : "hidden2"},
            {"label": "hiddenValue1", "value" : "hiddendashdsahdkhsk"}
          ]        
        ],
        labels: ["hiddenValue0", "hiddenValue1", "hiddenValue1"],
        nodesLength: 2,
        typeVal: "check1",
      }
    ],
    sortBy: "value",
    sortDirection: TableSortDirection.asc,
    checkboxOptions: [
      { label: "fresh", value: "fresh" },
      { label: "old", value: "old" },
      { label: "new", value: "new" },
    ],
    pageChange: (event) => {
      // console.log('page change event', event);
    },
    selectedChange: (event) => {
      // console.log('selection change event', event)
    },
    updateConfirmed: (event) => {
      console.log("row update confirmed", event);
    },

    sort: (arr, sortColumn, ascOrDsc) => {
      arr.sort((a, b) => {
        if (sortColumn === "date") {
          a = new Date(a[sortColumn]);
          b = new Date(b[sortColumn]);
          if (ascOrDsc === "asc") return a - b;
          else {
            return b - a;
          }
        }
        if (a[sortColumn] > b[sortColumn] && ascOrDsc === "asc") {
          return 1;
        } else {
          return -1;
        }
      });
      return arr;
    },
    sortColumn: (sortItem) => {
      // console.log('sort item!:', sortItem);
      this.tableNonPaginatedWithFilters.items = [
        ...this.tableNonPaginatedWithFilters.sort(
          sortItem.data,
          sortItem.sortBy,
          sortItem.sortDirection
        ),
      ];
    },
  };

  editableFilterTable = {
    itemCount: 5,
    items: [
      {
        label: "Item 1",
        value: "1",
        checkbox: "new",
        date: "1987-10-08 22:59:55 ",
        menuItems: [
          {
            // this label is important in order to trigger edit functionality in the core table components
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: "Item 2",
        value: "2",
        checkbox: "old",
        date: "2020-10-08 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: "Item 3",
        value: "4",
        checkbox: "new",
        date: "1987-10-06 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: "Item 4",
        value: "3",
        checkbox: "old",
        date: "2019-03-08 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: "Item 5",
        value: "4",
        checkbox: "new",
        date: "2020-05-19 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: undefined,
        value: "5",
        checkbox: "new",
        date: "2020-06-19 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
    ],
    sortBy: "value",
    sortDirection: TableSortDirection.asc,
    checkboxOptions: [
      { label: "fresh", value: "fresh" },
      { label: "old", value: "old" },
      { label: "new", value: "new" },
    ],
    pageChange: (event) => {
      // console.log('page change event', event);
    },
    selectedChange: (event) => {
      // console.log('selection change event', event)
    },
    updateConfirmed: (event) => {
      console.log("row update confirmed", event);
    },

    sort: (arr, sortColumn, ascOrDsc) => {
      arr.sort((a, b) => {
        if (sortColumn === "date") {
          a = new Date(a[sortColumn]);
          b = new Date(b[sortColumn]);
          if (ascOrDsc === "asc") return a - b;
          else {
            return b - a;
          }
        }
        if (a[sortColumn] > b[sortColumn] && ascOrDsc === "asc") {
          return 1;
        } else {
          return -1;
        }
      });
      return arr;
    },
    sortColumn: (sortItem) => {
      // console.log('sort item!:', sortItem);
      this.editableFilterTable.items = [
        ...this.editableFilterTable.sort(
          sortItem.data,
          sortItem.sortBy,
          sortItem.sortDirection
        ),
      ];
    },

    getAttributeValueOptions(attributeValue): any[] {
      return [
        {
          // this label is important in order to trigger edit functionality in the core table components
          label: TableEditOption.update,
          action: () => {},
        },
        {
          label: TableEditOption.delete,
          action: () => {
            this.delete(attributeValue);
          },
        },
      ];
    },
  };

  checkboxDropdownWithPills = {
    placeholderText: "Search",
    labelText: "Search Items",
    checkboxList: [
      {
        label: "Red",
        checked: false,
        value: "Red",
        name: "Color",
      },
      {
        label: "Yellow",
        checked: false,
        value: "Yellow",
        name: "Color",
      },
      {
        label: "Green",
        checked: false,
        value: "Green",
        name: "Color",
      },
      {
        label: "Blue",
        checked: false,
        value: "Blue",
        name: "Color",
      },
      {
        label: "Black",
        checked: false,
        value: "Black",
        name: "Color",
      },
      {
        label: "White",
        checked: false,
        value: "White",
        name: "Color",
      },
    ],
    changeData: () => {
      this.checkboxDropdownWithPills.checkboxList = [
        {
          label: "Blue",
          checked: false,
          value: "Blue",
          name: "Color",
        },
        {
          label: "Black",
          checked: false,
          value: "Black",
          name: "Color",
        },
        {
          label: "White",
          checked: false,
          value: "White",
          name: "Color",
        },
      ];
    },
  };

  prefilledEditableFilterTable = {
    itemCount: 5,
    items: [
      {
        label: "Item 1",
        value: "1",
        checkbox: "new",
        date: "1987-10-08 22:59:55 ",
        menuItems: [
          {
            // this label is important in order to trigger edit functionality in the core table components
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: "Item 2",
        value: "2",
        checkbox: "old",
        date: "1987-10-08 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: "Item 3",
        value: "4",
        checkbox: "new",
        date: "1987-10-06 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: "Item 4",
        value: "3",
        checkbox: "old",
        date: "2019-03-08 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: "Item 5",
        value: "4",
        checkbox: "new",
        date: "2020-05-19 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: undefined,
        value: "5",
        checkbox: "new",
        date: "2020-06-19 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
    ],
    sortBy: "value",
    initialColumnFilters: [
      {
        columnName: "value",
        columnFilter: {
          checkboxFilters: [{ label: "1", value: "1" }],
        },
      },
      {
        columnName: "date",
        columnFilter: {
          checkboxFilters: [
            { label: "1987-10-08 22:59:55 ", value: "1987-10-08 22:59:55 " },
          ],
        },
      },
    ],
    sortDirection: TableSortDirection.asc,
    checkboxOptions: [
      { label: "fresh", value: "fresh" },
      { label: "old", value: "old" },
      { label: "new", value: "new" },
    ],
    pageChange: (event) => {
      // console.log('page change event', event);
    },
    selectedChange: (event) => {
      // console.log('selection change event', event)
    },
    updateConfirmed: (event) => {
      console.log("row update confirmed", event);
    },

    sort: (arr, sortColumn, ascOrDsc) => {
      arr.sort((a, b) => {
        if (sortColumn === "date") {
          a = new Date(a[sortColumn]);
          b = new Date(b[sortColumn]);
          if (ascOrDsc === "asc") return a - b;
          else {
            return b - a;
          }
        }
        if (a[sortColumn] > b[sortColumn] && ascOrDsc === "asc") {
          return 1;
        } else {
          return -1;
        }
      });
      return arr;
    },
    sortColumn: (sortItem) => {
      // console.log('sort item!:', sortItem);
      this.editableFilterTable.items = [
        ...this.editableFilterTable.sort(
          sortItem.data,
          sortItem.sortBy,
          sortItem.sortDirection
        ),
      ];
    },

    getAttributeValueOptions(attributeValue): any[] {
      return [
        {
          // this label is important in order to trigger edit functionality in the core table components
          label: TableEditOption.update,
          action: () => {},
        },
        {
          label: TableEditOption.delete,
          action: () => {
            this.delete(attributeValue);
          },
        },
      ];
    },
  };

  toggleSwitch = {
    value: true,
    initialValue: true,
  };

  dialog = {
    openSinglePageDialog: () => {
      this.dialogService.open(
        SinglePageDialog,
        { content: "Single Page Dialog" },
        (result) => {
          console.log(result);
        }
      );
    },
    openMultiPageDialog: () => {
      this.dialogService.open(
        MultiPageDialog,
        { selectedValue: null },
        (result) => {
          console.log(result);
        }
      );
    },
    openFullPageDialog: () => {
      this.matDialog.open(FullScreenDialog, {
        height: "100%",
        width: "100%",
      });
    },
  };

  toast = {
    showSuccessToast: () => {
      this.toastService.success("Sandbox Toast", "Click me", () => {
        alert("toast button clicked!");
      });
    },
    showErrorToast: () => {
      this.toastService.error("Sandbox Toast", "Click me", () => {
        alert("toast button clicked!");
      });
    },
    showToast: () => {
      this.toastService.success("Sandbox Toast");
    },
    showToastWithCarriageReturns: () => {
      this.toastService.error("Sandbox Toast\r\n\r\nCarriage Returns");
    },
    showToastWithCarriageReturnsButton: () => {
      this.toastService.success(
        "Sandbox Toast With Button\r\n\r\nCarriage Returns\r\nCarriage Returns\r\nCarriage Returns\r\n",
        "Click me",
        () => {
          alert("toast button clicked!");
        }
      );
    },
    showSuccessToastFromBottom: () => {
      this.toastService.success(
        "Sandbox Toast From Bottom\r\n\r\nCarriage Returns\r\nCarriage Returns\r\nCarriage Returns\r\n",
        "",
        () => {},
        "right",
        "30"
      );
    },
    showBanner: () => {
      this.toastService.banner(
        "A new Enhanced Vehicle Detection bundle is available for your market.  Check it out."
      );
    },
    showInfoToast: () => {
      this.toastService.informational("[Info Message]");
    },
    showInfoToastWithButton: () => {
      this.toastService.informational("[Info Message]", "Click me", () => {
        alert("toast button clicked!");
      });
    },
  };

  tabs = {
    changeTab: (event) => console.log("tab changed", event),
    selectedIndex: 2,
  };

  //BRE Graph - refer https://apexcharts.com/docs/angular-charts/ for complete documentation

  chartOptions = {
    tooltip: {
      custom: (config) => {
        let customtooltip = "";
        let series = config.w.config.series;
        let dIndex = config.dataPointIndex;
        let currentTotal = 0;
        let legend2Total = 0;
        let legend1Total = 0;
        series.forEach((t) => {
          if (t.name === "Legend 1") {
            legend1Total = t.data[dIndex];
          }
          if (t.name === "Legend 2") {
            legend2Total = t.data[dIndex];
          }
          currentTotal += t.data[dIndex];
        });
        customtooltip =
          "<div><span>Total Count: " +
          currentTotal +
          "<br>Legend 1: " +
          legend1Total +
          "<br>Legend 2: " +
          legend2Total +
          "</span></div>";
        return customtooltip;
      },
    },
    noData: {
      text: "No data available",
      align: "center",
      verticalAlign: "middle",
      offsetX: 0,
      offsetY: -25,
      style: {
        color: undefined,
        fontSize: "14px",
        fontFamily: undefined,
      },
    },
    stroke: {
      curve: "straight",
    },
    legend: {
      show: true,
      onItemHover: {
        highlightDataSeries: false,
      },
    },
    series: [
      {
        name: "Legend 1",
        data: [],
        // data: [10, 50, 30, 70, 30, 20, 100, 45]
      },
      {
        name: "Legend 2",
        data: [],
        //data: [4, 12, 8, 17, 9, 10, 20, 15]
      },
    ],
    plotOptions: {
      bar: {
        borderRadius: 7,
        columnWidth: "40%",
      },
    },
    chart: {
      height: 400,
      width: 800,
      type: "bar",
      stacked: "true",
      stackType: "normal", //100%
      toolbar: false,
      animations: { enabled: false },
    },
    title: {
      text: "",
    },
    dataLabels: {
      enabled: false,
      background: {
        borderRadius: 10,
      },
    },
    xaxis: {
      title: { text: "X-Axis Variable" },
      categories: ["X1", "X2", "X3", "X4", "X5", "X6", "X7", "X8"],
    },
    yaxis: {
      title: { text: "Y-Axis Variable" },
    },
    colors: ["#FFBC0D", "#E02020"],
  };

  updateChartData = {
    handleClick: () =>
      (this.chartOptions.series = [
        {
          name: "Legend 1",
          data: [10, 50, 30, 70, 30, 20, 100, 45],
        },
        {
          name: "Legend 2",
          data: [4, 12, 8, 17, 9, 10, 20, 15],
        },
      ]),
  };

  timePicker = {
    timeToBeDisplayed: "",
    incrementMinutes: 30,
    minTime: "09:00",
    maxTime: "17:00",
  };

  constructor(
    private dialogService: DialogService,
    private toastService: ToastService,
    private route: ActivatedRoute,
    private router: Router,
    private fb: FormBuilder,
    private matDialog: MatDialog
  ) {
    setTimeout(() => {
      this.showStores = true;
    }, 7000);
    this.calendar._init();
    this.monthCalendar._init();
    this.form._init();
    this.navigationBar._init();
    this.paginatedTable._init();
  }
}

@Component({
  template: `
    <bre-dialog [showCloseButton]="true" headerText="this is header">
      <ng-template let-data let-close="close">
        {{ data.content }}
        <bre-button
          (onClick)="close(true)"
          label="Close"
          buttonClass="primary"
        ></bre-button>
        <bre-button
          (onClick)="close(false)"
          label="Cancel"
          buttonClass="secondary"
        ></bre-button>
      </ng-template>
    </bre-dialog>
  `,
})
export class SinglePageDialog {}

@Component({
  template: `
    <bre-dialog
      [showCloseButton]="true"
      [hideBackButton]="hideBackButton"
      (onPageChange)="updateHideBackButton($event)"
      [pagesCount]="3"
      footerText="this is footer"
    >
      <ng-template
        let-data
        let-close="close"
        let-currentPage="currentPage"
        let-next="nextPage"
        let-previous="previousPage"
      >
        <div style="width: 75vw; height: 50vh;" [ngSwitch]="currentPage">
          <div *ngSwitchCase="1">
            This is page 1.<br />
            <button (click)="next()">Go to next page</button>
          </div>
          <div *ngSwitchCase="2">
            This is page 2.<br />
            <input type="text" [(ngModel)]="data.selectedValue" /><br />
            <button (click)="previous()">Go to previous page</button>
            <button (click)="next()">Go to next page</button>
          </div>
          <div *ngSwitchCase="3">
            This is page 3.<br />
            Value entered is: {{ data.selectedValue }}<br />
            <button (click)="previous()">Go to previous page</button>
            <button (click)="close()">Close dialog</button>
          </div>
        </div>
      </ng-template>
    </bre-dialog>
  `,
})
export class MultiPageDialog {
  hideBackButton = false;
  updateHideBackButton(pageNumber) {
    this.hideBackButton = pageNumber === 3;
  }
}

@Component({
  template: `
    <bre-dialog-full-screen
      [isDialogFullScreen]="true"
      [showCloseButton]="true"
      [pagesCount]="2"
      [hideBackButton]="true"
      [headerText]="'Full Screen Dialog'"
      [progressbar_headers]="progressBarOptions"
      class="dialog-fullscreen"
      (onPageChange)="handlePageChange($event)"
    >
      <ng-template
        let-close="close"
        let-currentPage="currentPage"
        let-next="nextPage"
        let-previous="previousPage"
      >
        <div class="full-dialog">
          <div [hidden]="currentPage != 1">
            Page 1
            <div class="full-dialog__footer">
              <div class="full-dialog__footer-container">
                <div class="full-dialog__footer-right">
                  <bre-button
                    label="Next"
                    buttonClass="primary"
                    (onClick)="next($event)"
                  >
                  </bre-button>
                </div>
              </div>
            </div>
          </div>
          <div *ngIf="currentPage == 2">
            <div class="summary-wrapper">Page 2</div>
            <div class="full-dialog__footer">
              <div class="full-dialog__footer-container">
                <bre-button
                  label="Back"
                  buttonClass="secondary"
                  (onClick)="previous()"
                >
                </bre-button>
                <div class="full-dialog__footer-right">
                  <bre-button label="Confirm" buttonClass="primary">
                  </bre-button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </ng-template>
    </bre-dialog-full-screen>
  `
})
export class FullScreenDialog {
  currentPageNumber = 1;
  progressBarOptions = ["Page1 Heading", "Page1 Heading"];
  handlePageChange(pageNumber: number) {
    this.currentPageNumber = pageNumber;
  }
}
