export const and: (...filters: object[]) => object = (...filters: object[]) => {
  const sanitized = sanitizeFilters(filters);
  return sanitized?.length > 1 ? { AND: sanitized } : sanitized?.length === 1 ? sanitized[0] : null;
}

export const or: (...filters: object[]) => object = (...filters: object[]) => {
  const sanitized = sanitizeFilters(filters);
  return sanitized?.length > 1 ? { OR: sanitized } : sanitized?.length === 1 ? sanitized[0] : null;
}

export const operator: (operatorTerm: string, wildCard: boolean, filter: object) => object = (operatorTerm: string, wildCard: boolean, filter: object) => {
  const sanitized = sanitizeFilter(filter);
  if (!!sanitized && wildCard) {
    Object.entries(sanitized).forEach(([key, value]) => {
      sanitized[key] = value.map(x => `%${x}%`);
    });
  }
  return sanitized !== null ? { [operatorTerm]: sanitized } : null;
}

export const attribute: (attributeTerm: string, filter: object) => object = (attributeTerm: string, filter: object) => {
  const sanitized = sanitizeFilter(filter);
  return sanitized !== null ? { [attributeTerm]: sanitized } : null;
}

const sanitizeFilters: (filters: object[]) => object[] = (filters: object[]) => {
  const sanitized = filters?.map(sanitizeFilter)?.filter(x => !!x);
  return sanitized?.length > 0 ? sanitized : null;
};

const sanitizeFilter: (filter: object) => object = (filter: object) => {
  if (!filter) {
    return null;
  }
  const sanitized = Object.entries(filter).reduce((sanitized, [key, value]) => {
    if (value !== undefined && value !== null && (!Array.isArray(value) || value.length > 0)) {
      sanitized[key] = value;
    }
    return sanitized;
  }, {});
  return Object.entries(sanitized).length > 0 ? sanitized : null;
}