import { Injectable } from "@angular/core";
import { CoreModule } from "../../core.module";

@Injectable()
export class RBACService {
  components = {};
  authorizedComponents: string[];

  /**
   * Sets object of UI components
   * @param components object of role based UI components
   */
  setRoleBasedComponents(components: any) {
    this.components = components;
  }

  /**
   * Sets list of authorized components
   * @param components list of authorized components
   */
  setAuthorizedComponents(components: string[]) {
    this.authorizedComponents = components;
  }

  /**
   * Checks if user is authorized to access UI component
   * @method isAuthorized
   * @param component
   * @returns boolean
   */
  isAuthorized(component: string) {
    return this.authorizedComponents?.includes(component);
  }
}
