import { TestBed } from '@angular/core/testing';
import { ProductsService } from './products.service';
import { CoreModule } from '../../core.module';
import { HttpTestingController } from '@angular/common/http/testing';
import { HttpClientModule } from '@angular/common/http';
import { APP_INITIALIZER, Component } from '@angular/core';
import { CoreEnvService } from '../core-env.service';
import { ApiService } from '../api/api.service'

const get = jest.fn();
const post = jest.fn();

class ApiServiceMock {
    async get(url) {
        return get(url);
    }
    async post(url) {
        return post(url);
    }
}

describe('ReleasesApiService', () => {
    let injector: TestBed;
    let service: ProductsService;
    let httpMock: HttpTestingController;
    let productsGet = jest.fn(url => ({
        "data": [
            {
                "id": "5",
                "type": "products",
                "links": {
                    "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/products/5"
                },
                "attributes": {
                    "name": "aidt",
                    "created": "2022-10-13T12:49:33.000+00:00",
                    "updated": "2023-03-10T11:21:54.000+00:00"
                },
                "relationships": {
                    "productVersions": {
                        "links": {
                            "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/products/5/relationships/productVersions",
                            "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/products/5/productVersions"
                        }
                    }
                }
            },
            {
                "id": "6",
                "type": "products",
                "links": {
                    "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/products/6"
                },
                "attributes": {
                    "name": "bred",
                    "created": "2022-10-14T06:23:37.000+00:00",
                    "updated": "2023-03-10T09:15:27.000+00:00"
                },
                "relationships": {
                    "productVersions": {
                        "links": {
                            "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/products/6/relationships/productVersions",
                            "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/products/6/productVersions"
                        }
                    }
                }
            }
        ],
        "links": {
            "first": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/products?page[limit]=-1",
            "next": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/products?page[limit]=-1&page[offset]=-1",
            "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/products?page[limit]=-1"
        },
        "meta": {
            "totalResourceCount": 2
        }
    }));
    let productsVersionGet = jest.fn(url => (
        {
            "data": [
                {
                    "id": "11",
                    "type": "product_versions",
                    "links": {
                        "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/11"
                    },
                    "attributes": {
                        "versionName": "v1.6.1",
                        "isDeployed": "true",
                        "created": "2022-10-18T05:08:35.000+00:00",
                        "updated": "2022-10-18T05:16:07.000+00:00"
                    },
                    "relationships": {
                        "productApplications": {
                            "links": {
                                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/11/relationships/productApplications",
                                "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/11/productApplications"
                            }
                        },
                        "bundleReleaseApp": {
                            "links": {
                                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/11/relationships/bundleReleaseApp",
                                "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/11/bundleReleaseApp"
                            }
                        },
                        "products": {
                            "links": {
                                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/11/relationships/products",
                                "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/11/products"
                            }
                        },
                        "deploymentHistory": {
                            "links": {
                                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/11/relationships/deploymentHistory",
                                "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/11/deploymentHistory"
                            }
                        }
                    }
                },
                {
                    "id": "34",
                    "type": "product_versions",
                    "links": {
                        "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/34"
                    },
                    "attributes": {
                        "versionName": "v3.0.3",
                        "isDeployed": "true",
                        "created": "2022-10-20T09:06:40.000+00:00",
                        "updated": "2022-10-20T09:16:10.000+00:00"
                    },
                    "relationships": {
                        "productApplications": {
                            "links": {
                                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/34/relationships/productApplications",
                                "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/34/productApplications"
                            }
                        },
                        "bundleReleaseApp": {
                            "links": {
                                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/34/relationships/bundleReleaseApp",
                                "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/34/bundleReleaseApp"
                            }
                        },
                        "products": {
                            "links": {
                                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/34/relationships/products",
                                "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/34/products"
                            }
                        },
                        "deploymentHistory": {
                            "links": {
                                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/34/relationships/deploymentHistory",
                                "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions/34/deploymentHistory"
                            }
                        }
                    }
                }
            ],
            "links": {
                "first": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions?page[limit]=-1&filter[products.id]=5",
                "next": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions?page[limit]=-1&page[offset]=-1&filter[products.id]=5",
                "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_versions?page[limit]=-1&filter[products.id]=5"
            },
            "meta": {
                "totalResourceCount": 2
            }
        }
    ));
    let productsVersionApplicationsGet = jest.fn(url => (
        { "data": [{ "id": "181", "type": "product_applications", "links": { "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications/181" }, "attributes": { "applicationName": "aidt-asrservice", "applicationVersion": "1.14.0", "applicationType": "docker", "applicationUrl": "mcd.jfrog.io/brep-docker/aidt-asrservice:1.14.0", "created": "2022-10-31T11:48:52.000+00:00", "updated": "2023-02-09T08:25:37.000+00:00" }, "relationships": { "productVersions": { "links": { "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications/181/relationships/productVersions", "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications/181/productVersions" } } } }, { "id": "182", "type": "product_applications", "links": { "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications/182" }, "attributes": { "applicationName": "aiidt-cmservice", "applicationVersion": "1.14.1", "applicationType": "docker", "applicationUrl": "mcd.jfrog.io/brep-docker/aiidt-cmservice:1.14.1", "created": "2022-10-31T11:48:52.000+00:00", "updated": "2023-02-09T08:25:37.000+00:00" }, "relationships": { "productVersions": { "links": { "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications/182/relationships/productVersions", "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications/182/productVersions" } } } }, { "id": "183", "type": "product_applications", "links": { "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications/183" }, "attributes": { "applicationName": "aidt-ttsservice", "applicationVersion": "1.14.3", "applicationType": "docker", "applicationUrl": "mcd.jfrog.io/brep-docker/aidt-ttsservice:1.14.3", "created": "2022-10-31T11:48:52.000+00:00", "updated": "2023-02-09T08:25:37.000+00:00" }, "relationships": { "productVersions": { "links": { "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications/183/relationships/productVersions", "related": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications/183/productVersions" } } } }], "links": { "first": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications?page[limit]=20&filter[productVersions.id]=75", "last": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications?page[limit]=20&filter[productVersions.id]=75", "self": "http://asset-service.priv.dev.bre.mcd.com/restaurant_assets/product_applications?filter[productVersions.id]=75" }, "meta": { "totalResourceCount": 3 } }
    ));

    const env = {
        restaurantBaseUrl: 'https://asset.ui-api.dev.bre.mcd.com'
    }
    class ApiServiceMock {
        async get<T>(url: string): Promise<any> {
            if (url.includes('product_versions')) {
                return productsVersionGet(url);
            } else if (url.includes('product_applications')) {
                return productsVersionApplicationsGet(url)
            } else if (url.includes('products')) {
                return productsGet(url);
            }
        }
    }

    beforeEach(() => {
        TestBed.configureTestingModule({
            imports: [CoreModule],
            providers: [
                { provide: ApiService, useValue: new ApiServiceMock },
                {
                    provide: APP_INITIALIZER,
                    deps: [ProductsService],
                    useFactory: () => {
                        const init = () => {
                            CoreEnvService.set(env);
                        }
                        return init;
                    },
                    multi: true
                }
            ]
        });

        service = TestBed.inject(ProductsService);
    });
    afterEach(() => {
        productsGet.mockClear();
    });

    it('should be created', () => {
        expect(service).toBeTruthy();
    });


    it('ProductsService getProducts', async () => {
        spyOn(service, 'getProduct').and.callThrough();
        const docker = await service.getProduct();
        expect(productsGet).toHaveBeenCalled();
        expect(productsGet).toHaveBeenCalledWith("https://asset.ui-api.dev.bre.mcd.com/restaurant_assets/products?page[limit]=-1");
    });

    it('ProductsService getProductVersions', async () => {
        spyOn(service, 'getProductVersions').and.callThrough();
        const docker = await service.getProductVersions(8);
        expect(productsVersionGet).toHaveBeenCalled();
        expect(productsVersionGet).toHaveBeenCalledWith("https://asset.ui-api.dev.bre.mcd.com/restaurant_assets/product_versions?filter%5Bproducts.id%5D=8&page%5Blimit%5D=-1");
    });

    it('ProductsService getProductVersionApplications', async () => {
        spyOn(service, 'getProductVersionApplications').and.callThrough();
        const docker = await service.getProductVersionApplications(62);
        expect(productsVersionApplicationsGet).toHaveBeenCalled();
        expect(productsVersionApplicationsGet).toHaveBeenCalledWith("https://asset.ui-api.dev.bre.mcd.com/restaurant_assets/product_applications?filter[productVersions.id]=62&page[limit]=-1");
    });
});

