import { Injectable, TemplateRef } from '@angular/core';
import { ComponentType } from '@angular/cdk/portal';
import { CoreModule } from '../../core.module';
import { MatDialog } from '@angular/material/dialog';

@Injectable()
export class DialogService {

  constructor(private dialog: MatDialog) { }

  open(content: ComponentType<any> | TemplateRef<any>, data?: object, afterClosed?: (result: object) => void, overlayClose?: boolean): void {
    const dialogRef = this.dialog
      .open(content, { data, disableClose: !overlayClose });
    if (!!afterClosed) {
      dialogRef.afterClosed().subscribe(afterClosed);
    }
  }
}