import { TestBed } from '@angular/core/testing';

import { DialogService } from './dialog.service';
import { MatDialog } from '@angular/material/dialog';
import { Component } from '@angular/core';


const mockSubscribe = jest.fn();
const mockOpen = jest.fn((content, config) => ({ afterClosed: () => ({ subscribe: mockSubscribe }) }));
class MockMatDialog {
  open(content, config) {
    return mockOpen(content, config);
  }
}

@Component({})
class SomeComponent { }

describe('DialogService', () => {
  let service: DialogService;

  beforeEach(() => {
    TestBed.configureTestingModule({
      providers: [DialogService, { provide: MatDialog, useValue: new MockMatDialog() }]
    });
    service = TestBed.inject(DialogService);
  });
  afterEach(() => {
    mockSubscribe.mockClear();
    mockOpen.mockClear();
  });

  it('should be created', () => {
    expect(service).toBeTruthy();
  });

  it('should open dialog with correct configuration', () => {
    service.open(SomeComponent, { foo: 'bar' }, null, false);

    expect(mockOpen).toHaveBeenCalledWith(SomeComponent, { data: { foo: 'bar' }, disableClose: true });
    expect(mockSubscribe).not.toHaveBeenCalled();
  });

  it('should handle afterClosed callback', () => {
    const callback = () => { };
    service.open(SomeComponent, null, callback, true);

    expect(mockOpen).toHaveBeenCalledWith(SomeComponent, { data: null, disableClose: false });
    expect(mockSubscribe).toHaveBeenCalledWith(callback);
  });
});
