import { TemplateRef, Component, ContentChild, Inject, Input, Output, EventEmitter } from '@angular/core';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';

@Component({
    selector: 'bre-dialog',
    template: `
    <div class="dialog-container">
        <div class="dialog-header">
            <div class="dialog-header-back">
                <button *ngIf="!!pagesCount && !hideBackButton" [class]="context.currentPage > 1 ? 'show' : ''" (click)="context.previousPage()">
                    <i class="pi pi-chevron-left"></i>
                </button>
            </div>
            <div class="dialog-header-text">
                <ng-container *ngIf="!!headerText">
                    {{headerText}}
                </ng-container>
            </div>
            <div class="dialog-header-close">
                <button *ngIf="showCloseButton" (click)="context.close()">✕</button>
            </div>
        </div>
        <div class="dialog-body">
            <ng-template
                [ngTemplateOutlet]="dialogTemplate" 
                [ngTemplateOutletContext]="context">
            </ng-template>
        </div>
        <div class="dialog-footer">
            <div class="dialog-footer-pages" *ngIf="pagesCount > 0">
                <div *ngFor="let x of [].constructor(pagesCount); let index = index"
                     class="dialog-footer-pages-dot" [class]="index + 1 <= context.currentPage ? 'active' : ''"></div>
            </div>
            <div class="dialog-footer-text" *ngIf="!!footerText">
                {{footerText}}
            </div>
        </div>
    </div>
    `,
    styleUrls: ['./dialog.component.scss']
})
export class DialogComponent {
    @Input() showCloseButton: boolean;
    @Input() hideBackButton: boolean;
    @Input() pagesCount: number;
    @Input() headerText: string;
    @Input() footerText: string;

    @Output() onPageChange = new EventEmitter<number>();

    @ContentChild(TemplateRef) dialogTemplate;

    context: {
        $implicit: any,
        close: (dialogResult?: any) => void,
        currentPage: number,
        nextPage: () => void,
        previousPage: () => void
    };

    constructor(dialogRef: MatDialogRef<DialogComponent>, @Inject(MAT_DIALOG_DATA) data) {
        this.context = {
            $implicit: data,
            close: dialogRef.close.bind(dialogRef),
            currentPage: 1,
            nextPage: () => {
                if (this.context.currentPage < this.pagesCount) {
                    this.context.currentPage++;
                    this.onPageChange.emit(this.context.currentPage);
                }
            },
            previousPage: () => {
                if (this.context.currentPage > 1) {
                    this.context.currentPage--;
                    this.onPageChange.emit(this.context.currentPage);
                }
            }
        };
    }
}