import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { MAT_DIALOG_DATA, MatDialogRef } from '@angular/material/dialog';
import { DialogComponent } from './dialog.component';


const bind = jest.fn(() => 'bound!');
class MockMatDialogRef {
    close = {
        call: () => { },
        bind
    };
}

describe('DialogComponent', () => {
    let component: DialogComponent;
    let fixture: ComponentFixture<DialogComponent>;

    let dialogRef: MockMatDialogRef;

    beforeEach(async(() => {
        dialogRef = new MockMatDialogRef();
        TestBed.configureTestingModule({
            providers: [
                { provide: MatDialogRef, useValue: dialogRef },
                { provide: MAT_DIALOG_DATA, useValue: { foo: 'bar' } }
            ],
            declarations: [DialogComponent]
        }).compileComponents();
    }));

    beforeEach(() => {
        fixture = TestBed.createComponent(DialogComponent);
        component = fixture.componentInstance;
        fixture.detectChanges();
    });

    afterEach(() => {
        bind.mockClear();
    });

    it('should create', () => {
        expect(component).toBeTruthy();
    });

    it('should provide the correct context', () => {
        expect(component.context.$implicit).toEqual({ foo: 'bar' });
        expect(component.context.currentPage).toEqual(1);
        expect(component.context.nextPage).toBeDefined();
        expect(component.context.previousPage).toBeDefined();
        expect(component.context.close).toEqual('bound!');
        expect(bind).toHaveBeenCalledWith(dialogRef);
    });

    it('should correctly transition between pages', () => {
        component.pagesCount = 3;

        expect(component.context.currentPage).toEqual(1);

        component.context.previousPage();
        expect(component.context.currentPage).toEqual(1);

        component.context.nextPage();
        expect(component.context.currentPage).toEqual(2);

        component.context.nextPage();
        expect(component.context.currentPage).toEqual(3);

        component.context.nextPage();
        expect(component.context.currentPage).toEqual(3);

        component.context.previousPage();
        expect(component.context.currentPage).toEqual(2);
    });
});