# Usage

## Import DialogService
`import { DialogService } from '@bref/core';`

## Inject DialogService where needed
`constructor(private dialog: DialogService, ...) { }`

## Define content of dialog
```
@Component({
    template: `
        <bre-dialog [showCloseButton]="true">
            <ng-template let-data let-close="close">
                Received data from caller {{data.prop1}}
                <button (click)="close('ok')">I can send data back too on close</button>
            </ng-template>
        </bre-dialog>
    `
})
export class MyDialogComponent {}
```

## Open a dialog
```
const data = { prop1: 'foobar', ... }; //data to pass to dialog
const afterClosed = (result) => { //do something with result after dialog is closed };
const overlayClose = true; //indicates whether dialog can be closed by clicking outside; defaults to false
this.dialog.open(MyDialogComponent, data, afterClosed, overlayClose)
```

## More Information
DialogService is based on [Material Dialog](https://material.angular.io/components/dialog/overview)