import { Injectable } from "@angular/core";

@Injectable({
  providedIn: "root"
})
export class CoreEnvService {
  private static env = {
    msalIDToken: "",
    restaurantBaseUrl: "",
  };

  public static set(env) {
    Object.keys(CoreEnvService.env).forEach((key) => {
        CoreEnvService.env[key] = env[key];
    });
  }

  public static get(name) {
    return CoreEnvService.env[name];
  }

  public static setToken(token) {
    CoreEnvService.env["msalIDToken"] = token;
  }
}
