# Usage

## Import the ApiService
`import { ApiService } from '@bref/core';`

## Inject ApiService where needed
`constructor(private api: ApiService, ...) { }`

## GET requests
```
this.api.get('the_url', 'optional success message', 'optional failure message')
    .then(res => { 
        //handle success and do something with res
     })
    .catch(reason => { 
        //optionally handle failure and do something with reason
     });
```

## POST requests
```
this.api.post('the_url', { prop1: 'val1', prop2: 'body of request' }, 'optional success message', 'optional failure message')
    .then(res => { 
        //handle success and do something with res
     })
    .catch(reason => { 
        //optionally handle failure and do something with reason
     });
```

## PUT requests
```
this.api.put('the_url', { prop1: 'val1', prop2: 'body of request' }, 'optional success message', 'optional failure message')
    .then(res => { 
        //handle success and do something with res
     })
    .catch(reason => { 
        //optionally handle failure and do something with reason
     });
```

## DELETE requests
```
this.api.delete('the_url', 'optional success message', 'optional failure message')
    .then(res => { 
        //handle success and do something with res
     })
    .catch(reason => { 
        //optionally handle failure and do something with reason
     });
```

## More information
ApiService is built on top of [HttpClient](https://angular.io/guide/http).