import { Directive, Input, TemplateRef, ViewContainerRef } from "@angular/core";
import { RBACService } from "../services/rbac/rbac.service";

@Directive({
  selector: "[rbacComponent]",
})
export class RBACComponentDirective {
  @Input()
  set rbacComponent(componentKey: string) {
    if (componentKey) {
      const show = this.rbacService.isAuthorized(componentKey);
      if (show) {
        this.container.createEmbeddedView(this.templateRef);
      } else {
        this.container.clear();
      }
    }
  }
  constructor(
    private templateRef: TemplateRef<any>,
    private container: ViewContainerRef,
    private rbacService: RBACService
  ) {}
}
