import { CdkTableModule } from "@angular/cdk/table";
import { NgModule } from "@angular/core";
import { CommonModule } from "@angular/common";
import { FormsModule, ReactiveFormsModule } from "@angular/forms";
import { RouterModule } from "@angular/router";

import { AutoCompleteModule } from "primeng/autocomplete";
import { ButtonModule } from "primeng/button";
import { CalendarModule } from "primeng/calendar";
import { DropdownModule } from "primeng/dropdown";
import { InputTextModule } from "primeng/inputtext";
import { MultiSelectModule } from "primeng/multiselect";
import { OverlayPanelModule } from "primeng/overlaypanel";
import { ProgressSpinnerModule } from "primeng/progressspinner";
import { KeyFilterModule } from "primeng/keyfilter";
import { TooltipModule, Tooltip } from "primeng/tooltip";

import { AutoCompleteComponent } from "./components/auto-complete/auto-complete.component";
import { BreadcrumbsComponent } from "./components/breadcrumbs/breadcrumbs.component";
import { ButtonComponent } from "./components/button/button.component";
import { CardComponent } from "./components/card/card.component";
import { CalendarComponent } from "./components/calendar/calendar.component";
import { DialogComponent } from "./services/dialog/dialog.component";
import { DropdownComponent } from "./components/dropdown/dropdown.component";
import { FilterGroupComponent } from "./components/filter-group/filter-group.component";
import { GridColumnDirective } from "./components/grid/grid-column.directive";
import { GridRowDirective } from "./components/grid/grid-row.directive";
import { InputComponent } from "./components/input/input.component";
import { MultiSelectComponent } from "./components/multi-select/multi-select.component";
import { NavButtonComponent } from "./components/nav-button/nav-button.component";
import { NavigationBarComponent } from "./components/navigation-bar/navigation-bar.component";
import { QuickJumpComponent } from "./components/quick-jump/quick-jump.component";
import { StatusPillComponent } from "./components/status-pill/status-pill.component";
import {
  TableComponent,
  TableColumnDirective,
} from "./components/table/table.component";
import { ToggleSwitchComponent } from "./components/toggle-switch/toggle-switch.component";
import { SearchableSelectComponent } from "./components/searchable-select/searchable-select.component";
import { SplitButtonComponent } from "./components/split-button/split-button.component";
import { TabComponent } from "./components/tab-component/tab-component";
import { QuickJumpNavigationComponent } from "./components/quick-jump-navigation/quick-jump-navigation.component";

import { InfiniteScrollModule } from "ngx-infinite-scroll";

import { HttpClientModule } from "@angular/common/http";
import { MatCheckboxModule } from "@angular/material/checkbox";
import { MatDialogModule } from "@angular/material/dialog";
import { MatMenuModule } from "@angular/material/menu";
import { MatTooltipModule } from "@angular/material/tooltip";
import { MatExpansionModule } from "@angular/material/expansion";
import { MatListModule } from "@angular/material/list";

import { AdvancedFilterComponent } from "./components/filter-group/advanced-filter/advanced-filter.component";
import { TooltipDirective } from "./components/tooltip/tooltip.directive";
import { IconButtonComponent } from "./components/icon-button/icon-button.component";
import { InputErrorMessageComponent } from "./components/input-error-message/input-error-message.component";
import { SearchableDropdownComponent } from "./components/searchable-dropdown/searchable-dropdown.component";
import { PopoverMenuButtonComponent } from "./components/popover-menu-button/popover-menu-button.component";
import { ControlLabelComponent } from "./components/control-label/control-label.component";
import { ColumnFilterDropdownComponent } from "./components/column-filter-dropdown/column-filter-dropdown.component";
import { ColumnSortFilterComponent } from "./components/column-sort-filter/column-sort-filter.component";
import { ColumnCheckboxFilterComponent } from "./components/column-checkbox-filter/column-checkbox-filter.component";
import { ColumnDateFilterComponent } from "./components/column-date-filter/column-date-filter.component";
import { ColumnSearchFilterComponent } from "./components/column-search-filter/column-search-filter.component";
import { LottieModule } from "ngx-lottie";
import { LoaderComponent } from "./components/loader/loader.component";
import { FilterTableComponent } from "./components/filter-table/filter-table.component";
import { TabsComponentComponent } from "./components/tabs-component/tabs-component.component";
import { DataExceptionMessageComponent } from "./components/data-exception-message/data-exception-message.component";
import { ErrorIconComponent } from "./components/error-icon/error-icon.component";
import { NgApexchartsModule } from "ng-apexcharts";
import { GraphComponent } from "./components/graph/graph.component";
import { PermissionDeniedComponent } from "./components/permission-denied/permission-denied.component";
import { CategoryDropdownComponent } from "./components/category-dropdown/category-dropdown.component";
import { AccordionMenuComponent } from "./components/accordion-menu/accordion-menu.component";
import { RBACComponentDirective } from "./directives/rbac-component.directive";
import { RBACService } from "./services/rbac/rbac.service";
import { ProgressBarComponent } from "./components/progress-bar/progress-bar.component";
import { CheckboxComponent } from "./components/checkbox/checkbox.component";
import { FilterTableUpdateComponent } from "./components/filter-table-update/filter-table-update.component";
import { TimePickerComponent } from "./components/time-picker/time-picker.component";
import { FullscreenDialogComponent } from "./components/fullscreen-dialog/fullscreen-dialog.component";
import { ConfirmCloseDialogComponent } from "./components/confirm-close-dialog/confirm-close-dialog.component";
import { FullscreenDialogService } from "./services/fullscreen-dialog.service";
import { SelectHierarchyComponent } from "./components/select-hierarchy/select-hierarchy.component";
import { SearchableMultiselectComponent } from "./components/searchable-multiselect/searchable-multiselect.component";
import { RadioButtonComponent } from "./components/radio-button/radio-button.component";

import { SectionLoaderComponent } from "./components/section-loader/section-loader.component";
import { CheckboxDropdownWithPillsComponent } from "./components/checkbox-dropdown-with-pills/checkbox-dropdown-with-pills.component";
import { AddProductComponent } from "./components/add-product/add-product.component";
import { ProductsService } from "./services/products/products.service";
import { ApiService } from "./services/api/api.service";
import { AddProductSelectComponent } from "./components/add-product-select/add-product-select.component";
import { HierarchyApiService } from "./services/hierarchy/hierarchy-api.service";
import { ScopeService } from "./services/scope/scope.service";
import { SelectedRestaurantsDialogComponent } from "./components/selected-restaurants-dialog/selected-restaurants-dialog.component";
import { DialogService } from "./services/dialog/dialog.service";
import { StoreSelectComponent } from "./components/store-select/store-select.component"
import { StoreSelectionTypeComponent } from "./components/store-selection-type/store-selection-type.component"
export function playerFactory() {
  const res = import("lottie-web");
  return res;
}

// @dynamic
@NgModule({
  imports: [
    CdkTableModule,
    MatCheckboxModule,
    CommonModule,
    RouterModule,
    FormsModule,
    ReactiveFormsModule,
    ButtonModule,
    DropdownModule,
    InputTextModule,
    MultiSelectModule,
    InfiniteScrollModule,
    ProgressSpinnerModule,
    HttpClientModule,
    MatDialogModule,
    AutoCompleteModule,
    OverlayPanelModule,
    CalendarModule,
    KeyFilterModule,
    TooltipModule,
    MatMenuModule,
    MatTooltipModule,
    MatExpansionModule,
    MatListModule,
    LottieModule.forRoot({ player: playerFactory }),
    NgApexchartsModule,
  ],

  declarations: [
    AccordionMenuComponent,
    ButtonComponent,
    BreadcrumbsComponent,
    DialogComponent,
    FullscreenDialogComponent,
    DropdownComponent,
    InputComponent,
    MultiSelectComponent,
    CardComponent,
    GridRowDirective,
    GridColumnDirective,
    QuickJumpComponent,
    StatusPillComponent,
    TableComponent,
    TableColumnDirective,
    ToggleSwitchComponent,
    FilterGroupComponent,
    AutoCompleteComponent,
    NavButtonComponent,
    CalendarComponent,
    NavigationBarComponent,
    AdvancedFilterComponent,
    IconButtonComponent,
    SearchableSelectComponent,
    TooltipDirective,
    InputErrorMessageComponent,
    SearchableDropdownComponent,
    PopoverMenuButtonComponent,
    ControlLabelComponent,
    ColumnFilterDropdownComponent,
    ColumnSortFilterComponent,
    SplitButtonComponent,
    ColumnCheckboxFilterComponent,
    ColumnDateFilterComponent,
    ColumnSearchFilterComponent,
    SplitButtonComponent,
    LoaderComponent,
    FilterTableComponent,
    TabComponent,
    TabsComponentComponent,
    DataExceptionMessageComponent,
    ErrorIconComponent,
    GraphComponent,
    QuickJumpNavigationComponent,
    PermissionDeniedComponent,
    CategoryDropdownComponent,
    RBACComponentDirective,
    ProgressBarComponent,
    CheckboxComponent,
    FilterTableUpdateComponent,
    TimePickerComponent,
    ConfirmCloseDialogComponent,
    SectionLoaderComponent,
    SelectHierarchyComponent,
    SearchableMultiselectComponent,
    RadioButtonComponent,
    AddProductComponent,
    AddProductSelectComponent,
    CheckboxDropdownWithPillsComponent,
    AddProductComponent,
    AddProductSelectComponent,
    SelectedRestaurantsDialogComponent,
    StoreSelectComponent,
    StoreSelectionTypeComponent
  ],

  exports: [
    CommonModule,
    AccordionMenuComponent,
    ButtonComponent,
    BreadcrumbsComponent,
    DropdownComponent,
    InputComponent,
    MultiSelectComponent,
    CardComponent,
    GridRowDirective,
    GridColumnDirective,
    QuickJumpComponent,
    StatusPillComponent,
    TableComponent,
    TableColumnDirective,
    ToggleSwitchComponent,
    HttpClientModule,
    MatDialogModule,
    MatTooltipModule,
    DialogComponent,
    FullscreenDialogComponent,
    FilterGroupComponent,
    AutoCompleteComponent,
    NavButtonComponent,
    CalendarComponent,
    NavigationBarComponent,
    IconButtonComponent,
    SearchableSelectComponent,
    TooltipDirective,
    SearchableDropdownComponent,
    PopoverMenuButtonComponent,
    ControlLabelComponent,
    ColumnFilterDropdownComponent,
    ColumnSortFilterComponent,
    SplitButtonComponent,
    LoaderComponent,
    FilterTableComponent,
    TabComponent,
    TabsComponentComponent,
    DataExceptionMessageComponent,
    ErrorIconComponent,
    GraphComponent,
    QuickJumpNavigationComponent,
    PermissionDeniedComponent,
    CategoryDropdownComponent,
    RBACComponentDirective,
    ProgressBarComponent,
    ColumnCheckboxFilterComponent,
    CheckboxComponent,
    FilterTableUpdateComponent,
    InputErrorMessageComponent,
    TimePickerComponent,
    SectionLoaderComponent,
    SelectHierarchyComponent,
    SearchableMultiselectComponent,
    AddProductComponent,
    AddProductSelectComponent,
    RadioButtonComponent,
    CheckboxDropdownWithPillsComponent,
    AddProductComponent,
    AddProductSelectComponent,
    SelectedRestaurantsDialogComponent,
    StoreSelectComponent,
    StoreSelectionTypeComponent
  ],

  providers: [
    RBACService,
    FullscreenDialogService,
    ProductsService,
    ApiService,
    HierarchyApiService,
    ScopeService,
    ProductsService,
    DialogService,
  ],
})
export class CoreModule {}
