import { Directive, HostBinding, Input, ElementRef, NgZone, AfterViewInit } from '@angular/core';
import { Tooltip } from 'primeng/tooltip';

@Directive({
  selector: '[breTooltip]', 
})

export class TooltipDirective extends Tooltip {
  @Input('breTooltip') text: string;
  @Input() disableTooltip;
  @Input() escapeTooltipHtmlTags;
  
  constructor(el: ElementRef, zone: NgZone) {
    super(el, zone);
    this.tooltipPosition = "top";
  }
  
  ngOnInit() {
    this.disabled = this.disableTooltip;
    this.escape = this.escapeTooltipHtmlTags;
  }
}
