import { Component, ElementRef, NgZone } from '@angular/core';
import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { TooltipModule } from 'primeng/tooltip';
import { TooltipDirective } from './tooltip.directive';

@Component({
  selector: 'bre--mock',
  template: '<div breTooltip="test">Mock Component</div>'
})
class MockComponent {}

describe('TooltipComponent', () => {
  let directive: TooltipDirective;
  let component: MockComponent;
  let fixture: ComponentFixture<MockComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [ TooltipModule ],
      declarations: [ TooltipDirective, MockComponent ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(MockComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create an instance', () => {
    const directive = new TooltipDirective(new ElementRef<MockComponent>(component), new NgZone({}));
    expect(directive).toBeTruthy();
  });
});
