import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { ReactiveFormsModule, FormGroup, FormControl } from '@angular/forms';
import { ToggleSwitchComponent } from './toggle-switch.component';
import { ControlLabelComponent } from '../control-label/control-label.component';
import { TooltipDirective } from '../tooltip/tooltip.directive';
import { PopoverMenuButtonComponent } from '../popover-menu-button/popover-menu-button.component'
import { IconButtonComponent } from '../icon-button/icon-button.component';
import { MatMenuModule } from '@angular/material/menu';

describe('ToggleSwitchComponent', () => {
  let component: ToggleSwitchComponent;
  let fixture: ComponentFixture<ToggleSwitchComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [ ReactiveFormsModule, MatMenuModule ],
      declarations: [ ToggleSwitchComponent, ControlLabelComponent, TooltipDirective, PopoverMenuButtonComponent, IconButtonComponent ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(ToggleSwitchComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should display a label if one has been declared', () => {
    component.label = "Test";
    component.ngOnInit();
    fixture.detectChanges();
    expect(component.componentUUID).toContain('test');
  });

  it('should stop event propagation on click', () => {
    const mockEvent = { stopPropagation: () => {} };
    const spy = spyOn(mockEvent, 'stopPropagation');
    component.toggleClick(mockEvent)
    expect(spy).toHaveBeenCalled();
  });

  it('should toggle the value on change', () => {
    component.value = false;
    component.onChange();
    expect(component.value).toBeTruthy();
  });

  it('should mark the form field as pristine if reset to its initial value and dirty if set to another value', () => {
    component.initialValue = false;
    component.value = true;
    component.controlName = 'testControl';
    component.parentForm = new FormGroup({ 'testControl': new FormControl([''])});
    const pristineSpy = spyOn(component.parentForm.get(component.controlName), 'markAsPristine');
    component.onChange();

    expect(pristineSpy).toHaveBeenCalled();

    const dirtySpy = spyOn(component.parentForm.get(component.controlName), 'markAsDirty');
    component.onChange();

    expect(dirtySpy).toHaveBeenCalled();
  });
});
