import {
  AfterViewChecked,
  Component,
  Input,
  OnInit,
  Output,
  EventEmitter
} from "@angular/core";

@Component({
  selector: "bre-time-picker",
  templateUrl: "./time-picker.component.html",
  styleUrls: ["./time-picker.component.scss"]
})
export class TimePickerComponent implements OnInit {
  @Input() timeToBeDisplayed: string;
  @Input() incrementMinutes: number;
  @Input() minTime: string;
  @Input() maxTime: string;
  @Input() dayId: string;
  @Output() timeSelectionEvent: EventEmitter<object> = new EventEmitter();
  timeSelected: string;
  year: number;
  month: number;
  day: number;

  constructor() {}
  ngOnInit(): void {
    this.timeSelected = this.timeToBeDisplayed;
    const dateToday = new Date();
    this.year = dateToday.getFullYear();
    this.month = dateToday.getMonth();
    this.day = dateToday.getDay();
  }

  increaseTimer() {
    const updatedTime = this.getUpdatedTime();
    const updatedTimeSelected = new Date(
      updatedTime.getTime() + this.incrementMinutes * 60000
    );
    this.getFormattedSelectedTime(updatedTimeSelected);
  }

  decreaseTimer() {
    const updatedTime = this.getUpdatedTime();
    const updatedTimeSelected = new Date(
      updatedTime.getTime() - this.incrementMinutes * 60000
    );
    this.getFormattedSelectedTime(updatedTimeSelected);
  }

  getUpdatedTime(): Date {
    this.timeSelected =
      this.timeSelected === "" ? this.minTime : this.timeSelected;
    const splittedTime = this.splitTime();
    const timeSelectedVal = new Date(
      this.year,
      this.month,
      this.day,
      splittedTime.hours,
      splittedTime.minutes
    );
    return timeSelectedVal;
  }

  splitTime() {
    const splitTime = this.timeSelected.split(":");
    return { hours: Number(splitTime[0]), minutes: Number(splitTime[1]) };
  }

  getFormattedSelectedTime(updatedTime) {
    let selectedHour = updatedTime.getHours();
    let selectedMin = updatedTime.getMinutes();
    if (selectedHour < 10) {
      selectedHour = "0" + selectedHour;
    }
    if (selectedMin < 10) {
      selectedMin = "0" + selectedMin;
    }
    this.timeSelected = `${selectedHour}:${selectedMin}`;
    this.timeSelectionEvent?.emit({
      originalValue: this.timeToBeDisplayed,
      newValue: this.timeSelected,
      id: this.dayId
    });
  }
}
