import { TimePickerComponent } from "./time-picker.component";
import { async, ComponentFixture, TestBed } from "@angular/core/testing";
import { CUSTOM_ELEMENTS_SCHEMA } from "@angular/core";
import { ReactiveFormsModule, FormsModule } from "@angular/forms";
import { IconButtonComponent } from "../icon-button/icon-button.component";

describe("TimePickerComponent", () => {
  let component: TimePickerComponent;
  let fixture: ComponentFixture<TimePickerComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [ReactiveFormsModule, FormsModule],
      declarations: [TimePickerComponent, IconButtonComponent],
      schemas: [CUSTOM_ELEMENTS_SCHEMA],
    }).compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(TimePickerComponent);
    component = fixture.componentInstance;
    component.timeToBeDisplayed = "09:00";
    component.incrementMinutes = 30;
    component.minTime = "09:00";
    component.maxTime = "17:00";
    fixture.detectChanges();
  });

  it("should create", () => {
    expect(component).toBeTruthy();
  });

  it("should increase the timer", () => {
    spyOn(component, "increaseTimer").and.callThrough();
    component.increaseTimer();
    expect(component.timeSelected).toBe("09:30");
  });

  it("should decrease the timer", () => {
    component.timeSelected = "17:00";
    spyOn(component, "decreaseTimer").and.callThrough();
    component.decreaseTimer();
    expect(component.timeSelected).toBe("16:30");
  });
});
