import {
  Component,
  AfterContentInit,
  ContentChildren,
  QueryList,
  ViewEncapsulation,
  Input,
  Output,
  EventEmitter,
  SimpleChanges,
} from "@angular/core";
import { TabComponent } from "../tab-component/tab-component";

@Component({
  selector: "bre-tabs",
  templateUrl: "./tabs-component.component.html",
  styleUrls: ["./tabs-component.component.scss"],
  encapsulation: ViewEncapsulation.None,
})
export class TabsComponentComponent implements AfterContentInit {
  @Input() selectedTab: number;
  @Output() selectedTabChange: EventEmitter<any> = new EventEmitter();

  @ContentChildren(TabComponent) tabs: QueryList<TabComponent>;

  // contentChildren are set
  ngAfterContentInit() {
    // get all active tabs
    let activeTabs = this.tabs.filter((tab) => tab.active);
    this.tabs.toArray().forEach((tab, index) => (tab.index = index));

    //if there is no active tab set, activate the first
    if (this.selectedTab >= 0) {
      this.selectTab(
        this.tabs.filter((item) => item.index === this.selectedTab)
      );
    } else {
      this.selectTab(this.tabs.first);
    }
  }

  selectTab(tab) {
    // deactivate all tabs
    this.tabs.toArray().forEach((tab) => (tab.active = false));

    // activate the tab the user has clicked on.
    if (tab && tab.length > 0) {
      tab.forEach((element) => {
        element.active = true;
      });
    } else if (tab) {
      tab.active = true;
    }
    this.selectedTabChange.emit(tab);
  }
}
