import { async, ComponentFixture, TestBed, fakeAsync } from '@angular/core/testing';
import { Component, OnInit, CUSTOM_ELEMENTS_SCHEMA, ComponentFactoryResolver } from '@angular/core';
import { By } from '@angular/platform-browser';

import { TabsComponentComponent } from './tabs-component.component';
import { TabComponent } from '../tab-component/tab-component';
@Component({
  selector: 'bre-mock-component',
  template: `<bre-tabs [selectedTab]='1'>
    <bre-tab [tabTitle]="'Tab 1'"></bre-tab>
    <bre-tab [tabTitle]="'Tab 2'"></bre-tab>
    <bre-tab [tabTitle]="'Tab 3'"></bre-tab>
  </bre-tabs>`
})
export class TabsContainerMockComponent {
  TabsComponentComponent;
  selectTab() {}
}

describe('TabsComponentComponent', () => {
  let component: TabsComponentComponent;
  let fixture: ComponentFixture<TabsComponentComponent>;
  let component1: TabsComponentComponent;
  let fixture1: ComponentFixture<TabsContainerMockComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ TabsComponentComponent, TabComponent, TabsContainerMockComponent ],
      schemas: [CUSTOM_ELEMENTS_SCHEMA]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(TabsComponentComponent);
    component = fixture.debugElement.children[0].componentInstance;
    fixture.detectChanges();
    fixture1 = TestBed.createComponent(TabsContainerMockComponent);
    component1 = fixture1.debugElement.children[0].componentInstance;
    fixture1.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeDefined();
    expect(component1).toBeDefined();
  });
 
  it('expect to contain 3 tabs', () => {
    fixture1.detectChanges();
    expect(component1.tabs.length).toBe(3);
    expect(fixture1.nativeElement.querySelectorAll('li').length).toEqual(3);
  });

  it('expect to contain 3 tabs', () => {
    fixture1.detectChanges();
    expect(fixture1.nativeElement.querySelectorAll('li').length).toEqual(3);
  });
  
  it('expect TAB 2 to be active', () => {
    fixture1.detectChanges();
    expect(fixture1.nativeElement.querySelectorAll('li')[1].getAttribute('class')).toContain('active')
  });

  it('click on TAB 3 and expect to have been called', fakeAsync(() => {
    fixture1.debugElement.nativeElement.querySelectorAll('li')[2].click();
    fixture1.detectChanges();
    fixture.whenStable().then(() => {
      expect(fixture1.nativeElement.querySelectorAll('li')[2].getAttribute('class')).toContain('active')
    });
  }));
});
