import { Component, OnChanges, OnInit } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { CdkTableModule } from '@angular/cdk/table';
import { MatCheckboxModule } from '@angular/material/checkbox';
import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { DropdownModule } from 'primeng/dropdown';
import { ButtonModule } from 'primeng/button';
import { TableComponent, TableColumnDirective, TableRowClickEvent, TablePageChangeEvent, PageSizes } from './table.component';
import { ColumnFilterDropdownComponent } from '../column-filter-dropdown/column-filter-dropdown.component';
import { IconButtonComponent } from '../icon-button/icon-button.component';
import { ColumnSortFilterComponent } from '../column-sort-filter/column-sort-filter.component';
import { ButtonComponent } from '../button/button.component';
import { OverlayPanel, OverlayPanelModule } from 'primeng/overlaypanel';
import { ProgressSpinnerModule } from 'primeng/progressspinner';
import { MultiSelectComponent } from '../multi-select/multi-select.component';
import { ControlLabelComponent } from '../control-label/control-label.component';
import { MultiSelect, MultiSelectModule } from 'primeng/multiselect';
import { InputErrorMessageComponent } from '../input-error-message/input-error-message.component';
import { TooltipDirective } from '../tooltip/tooltip.directive';
import { PopoverMenuButtonComponent } from '../popover-menu-button/popover-menu-button.component';
import { MatMenuModule } from '@angular/material/menu';
import { AutoCompleteComponent } from '../auto-complete/auto-complete.component';
import { AutoCompleteModule } from 'primeng/autocomplete';
import { ColumnCheckboxFilterComponent } from '../column-checkbox-filter/column-checkbox-filter.component';
import { ColumnSearchFilterComponent } from '../column-search-filter/column-search-filter.component';
import { ColumnDateFilterComponent } from '../column-date-filter/column-date-filter.component';
import { InputComponent } from '../input/input.component';
import { CalendarComponent } from '../calendar/calendar.component';
import { KeyFilterModule } from 'primeng/keyfilter';
import { InputTextModule } from 'primeng/inputtext';
import { CalendarModule } from 'primeng/calendar';
import { StatusPillComponent } from '../status-pill/status-pill.component';
import { ErrorIconComponent } from '../error-icon/error-icon.component';
import { ReactiveFormsModule } from '@angular/forms';

@Component({
  selector: 'bre-mock',
  template: `
  <bre-table [data]="data" [itemCount]="itemCount" [currentPage]="page" (onRowClick)="handleRowClick($event)" (onPageChange)="handlePageChange($event)">
    <bre-table-column sortable="true" name="foo" label="Foo123">
      <ng-template let-item>
        {{item.foo}}
      </ng-template>
    </bre-table-column>
    <bre-table-column sortable="true" name="bar" label="Bar987">
      <ng-template let-item>
        {{item.bar}}
      </ng-template>
    </bre-table-column>
  </bre-table>`
})
class MockComponent {
  data = [
    { foo: 'foo1', bar: 'bar1', xyz: 'xyz1' },
    { foo: 'xyz2', bar: 'foo42', xyz: 'xyz2' },
    { foo: 'foo1', bar: 'bar1', xyz: 'xyz1' },
    { foo: 'xyz2', bar: 'foo42', xyz: 'xyz2' },
    { foo: 'foo1', bar: 'bar1', xyz: 'xyz1' },
    { foo: 'xyz2', bar: 'foo42', xyz: 'xyz2' },
    { foo: 'foo1', bar: 'bar1', xyz: 'xyz1' },
    { foo: 'xyz2', bar: 'foo42', xyz: 'xyz2' },
    { foo: 'foo1', bar: 'bar1', xyz: 'xyz1' },
    { foo: 'xyz2', bar: 'foo42', xyz: 'xyz2' },
    { foo: 'foo1', bar: 'bar1', xyz: 'xyz1' },
    { foo: 'xyz2', bar: 'foo42', xyz: 'xyz2' },
    { foo: 'foo1', bar: 'bar1', xyz: 'xyz1' },
    { foo: 'xyz2', bar: 'foo42', xyz: 'xyz2' },
    { foo: 'foo1', bar: 'bar1', xyz: 'xyz1' },
    { foo: 'xyz2', bar: 'foo42', xyz: 'xyz2' },
    { foo: 'foo1', bar: 'bar1', xyz: 'xyz1' },
    { foo: 'xyz2', bar: 'foo42', xyz: 'xyz2' },
    { foo: 'foo1', bar: 'bar1', xyz: 'xyz1' },
    { foo: 'xyz2', bar: 'foo42', xyz: 'xyz2' },
    { foo: 'foo1', bar: 'bar1', xyz: 'xyz1' },
    { foo: 'xyz2', bar: 'foo42', xyz: 'xyz2' },
    { foo: 'foo1', bar: 'bar1', xyz: 'xyz1' },
    { foo: 'xyz2', bar: 'foo42', xyz: 'xyz2' },
    { foo: 'foo1', bar: 'bar1', xyz: 'xyz1' },
    { foo: 'foo1', bar: 'bar1', xyz: 'xyz1' },
    { foo: 'foo1', bar: 'bar1', xyz: 'xyz1' },
  ];

  itemCount = 27;
  sortBy = 'bar';
  sortDirection = 'asc';
  page = 2;

  handleRowClick(rowClickEvent: TableRowClickEvent<object>): void { }

  handlePageChange(pageChangeEvent: TablePageChangeEvent): void { }
}

describe('TableComponent', () => {
  let component: MockComponent;
  let fixture: ComponentFixture<MockComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [
        FormsModule,
        CdkTableModule,
        DropdownModule,
        ButtonModule,
        MatCheckboxModule,
        OverlayPanelModule,
        ButtonModule,
        ProgressSpinnerModule,
        ReactiveFormsModule,
        MultiSelectModule,
        MatMenuModule,
        AutoCompleteModule,
        KeyFilterModule,
        InputTextModule,
        CalendarModule
      ],
      declarations: [
        TableComponent,
        TableColumnDirective,
        MockComponent,
        ColumnFilterDropdownComponent,
        IconButtonComponent,
        ButtonComponent,
        ColumnSortFilterComponent,
        MultiSelectComponent,
        ControlLabelComponent,
        InputErrorMessageComponent,
        TooltipDirective,
        PopoverMenuButtonComponent,
        AutoCompleteComponent,
        ColumnSearchFilterComponent,
        ColumnDateFilterComponent,
        InputComponent,
        CalendarComponent,
        ColumnCheckboxFilterComponent,
        StatusPillComponent,
        ErrorIconComponent
      ]
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(MockComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should render header labels correctly', () => {
    const headers = fixture.nativeElement.querySelectorAll('th');
    expect(headers.length).toEqual(2);
    expect(headers[0].textContent).toContain('Foo123');
    expect(headers[1].textContent).toContain('Bar987');
  });

  it('should render column content correctly', () => {
    const rows = fixture.nativeElement.querySelectorAll('tbody tr');
    expect(rows.length).toEqual(2);

    const firstRowColumns = rows[0].querySelectorAll('td');
    const firstRowFirstColumnValue = firstRowColumns[0].textContent;
    const firstRowSecondColumnValue = firstRowColumns[1].textContent;
    expect(firstRowColumns.length).toEqual(2);
    expect(firstRowFirstColumnValue).toContain('foo1');
    expect(firstRowSecondColumnValue).toContain('bar1');

    const secondRowColumns = rows[1].querySelectorAll('td');
    const secondRowFirstColumnValue = secondRowColumns[0].textContent;
    const secondRowSecondColumnValue = secondRowColumns[1].textContent;
    expect(secondRowColumns.length).toEqual(2);
    expect(secondRowFirstColumnValue).toContain('foo1');
    expect(secondRowSecondColumnValue).toContain('bar1');
  });

  it('should handle row clicking correctly', () => {
    spyOn(component, 'handleRowClick');

    fixture.nativeElement.querySelector('tbody tr').click();

    expect(component.handleRowClick).toHaveBeenCalledWith({
      index: 0,
      item: { foo: 'foo1', bar: 'bar1', xyz: 'xyz1' }
    });
  });

  it('should handle pagination changes correctly', () => {
    spyOn(component, 'handlePageChange');

    fixture.nativeElement.querySelector('.pagination button .pi-chevron-right').click();

    expect(component.handlePageChange).toHaveBeenCalledWith({
      page: 2,
      pageSize: PageSizes.TwentyFive,
      sortBy: undefined,
      sortDirection: undefined
    });
  });

  xit('should display a sort arrow on the correct header cell on load', () => {
    const headerCell = fixture.nativeElement.querySelector('table th:nth-child(2) i');

    expect(headerCell).toBeTruthy();
  });

  xit('should display a sort arrow on the correct header cell on hover', () => {
    const event = new MouseEvent('mouseenter', {
      view: window,
      bubbles: true,
      cancelable: true,
    });
    const headerCell = fixture.nativeElement.querySelector(
      'table th:first-child'
    );
    headerCell.dispatchEvent(event);
    expect(fixture.nativeElement.querySelector('table th:first-child i')).toBeTruthy();
  });

  xit('should change sortDirection on click', () => {
    spyOn(component, 'handlePageChange');
    const headerCell = fixture.nativeElement.querySelector('table th:first-child i');

    headerCell.click();

    expect(component.handlePageChange).toHaveBeenCalledWith({
      page: 2,
      pageSize: PageSizes.TwentyFive,
      sortBy: 'foo',
      sortDirection: 'asc',
    });
  });

  it('should display ... on pager correctly', () => {
    component.page = 4;
    expect(fixture.nativeElement.querySelectorAll('.pagination .first-page-button > span').length).toEqual(0);

    component.page = 5;
    fixture.detectChanges();
    expect(fixture.nativeElement.querySelectorAll('.pagination .first-page-button > span').length).toEqual(0);

    component.page = 6;
    fixture.detectChanges();
    expect(fixture.nativeElement.querySelectorAll('.pagination .first-page-button > span').length).toEqual(0);
  });
});

@Component({
  selector: 'bre-mock-check',
  template: `
  <bre-table [data]="data" [itemCount]="itemCount" [currentPage]="page" [enableCheckBox]="true" [clearSelection]="isSelectionCleared"
        (onSelectChange)="updateSelected($event)" (onPageChange)="handlePageChange($event)">
    <bre-table-column sortable="false" checkBox="true"></bre-table-column>
    <bre-table-column sortable="true" name="foo" label="Foo123">
      <ng-template let-item>
        {{item.foo}}
      </ng-template>
    </bre-table-column>
    <bre-table-column sortable="true" name="bar" label="Bar987">
      <ng-template let-item>
        {{item.bar}}
      </ng-template>
    </bre-table-column>
  </bre-table>`
})
class MockComponentCheck implements OnChanges {
  data = [
    { foo: 'foo1', bar: 'bar1', xyz: 'xyz1' },
    { foo: 'xyz2', bar: 'foo42', xyz: 'xyz2' }
  ];

  itemCount = 179;
  sortBy = 'bar';
  sortDirection = 'asc';
  page = 2;
  selected = [];
  isSelectionCleared;

  ngOnChanges(changes): void {
    if (changes.selectedReviews.length < 1 && this.isSelectionCleared) {
      this.isSelectionCleared = false;
    }
  }
  handlePageChange(pageChangeEvent: TablePageChangeEvent): void { }
  updateSelected($event) {
    this.selected = $event
  }
}

describe('TableComponent', () => {
  let component: MockComponentCheck;
  let fixture: ComponentFixture<MockComponentCheck>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [
        FormsModule,
        CdkTableModule,
        DropdownModule,
        ButtonModule,
        MatCheckboxModule,
        OverlayPanelModule,
        ButtonModule,
        ProgressSpinnerModule,
        ReactiveFormsModule,
        MultiSelectModule,
        MatMenuModule,
        AutoCompleteModule,
        KeyFilterModule,
        InputTextModule,
        CalendarModule
      ],
      declarations: [
        TableComponent,
        TableColumnDirective,
        MockComponentCheck,
        ColumnFilterDropdownComponent,
        IconButtonComponent,
        ButtonComponent,
        ColumnSortFilterComponent,
        MultiSelectComponent,
        ControlLabelComponent,
        InputErrorMessageComponent,
        TooltipDirective,
        PopoverMenuButtonComponent,
        AutoCompleteComponent,
        ColumnSearchFilterComponent,
        ColumnDateFilterComponent,
        InputComponent,
        CalendarComponent,
        ColumnCheckboxFilterComponent,
        StatusPillComponent,
        ErrorIconComponent
      ]
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(MockComponentCheck);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should render header labels correctly', () => {
    const headers = fixture.nativeElement.querySelectorAll('th');
    expect(headers.length).toEqual(3);
    expect(headers[0].textContent).toContain('');
    expect(headers[1].textContent).toContain('Foo123');
    expect(headers[2].textContent).toContain('Bar987');
  });

  it('should render column content correctly', () => {
    const rows = fixture.nativeElement.querySelectorAll('tbody tr');
    expect(rows.length).toEqual(2);

    // const firstRowColumns = rows[0].querySelectorAll('td');
    // const firstRowFirstColumnValue = firstRowColumns[0].textContent;
    // const firstRowSecondColumnValue = firstRowColumns[1].textContent;
    // const firstRowThirdColumnValue = firstRowColumns[2].textContent;
    // expect(firstRowColumns.length).toEqual(3);
    // expect(firstRowFirstColumnValue).toContain('');
    // expect(firstRowSecondColumnValue).toContain('foo1');
    // expect(firstRowThirdColumnValue).toContain('bar1');

    // const secondRowColumns = rows[1].querySelectorAll('td');
    // const secondRowFirstColumnValue = secondRowColumns[0].textContent;
    // const secondRowSecondColumnValue = secondRowColumns[1].textContent;
    // const secondRowThirdColumnValue = secondRowColumns[2].textContent;
    // expect(secondRowColumns.length).toEqual(3);
    // expect(secondRowFirstColumnValue).toContain('');
    // expect(secondRowSecondColumnValue).toContain('xyz2');
    // expect(secondRowThirdColumnValue).toContain('foo42');
  });

  // it('should handle row clicking correctly', () => {
  //   spyOn(component, 'handleRowClick');

  //   fixture.nativeElement.querySelector('tbody tr').click();

  //   expect(component.handleRowClick).toHaveBeenCalledWith({
  //     index: 0,
  //     item: { foo: 'foo1', bar: 'bar1', xyz: 'xyz1' }
  //   });
  // });

  it('should handle pagination changes correctly', () => {
    spyOn(component, 'handlePageChange');

    fixture.nativeElement.querySelector('.pagination button .pi-chevron-right').click();

    expect(component.handlePageChange).toHaveBeenCalledWith({
      page: 3,
      pageSize: PageSizes.TwentyFive,
      sortBy: undefined,
      sortDirection: undefined
    });
  });

  xit('should display a sort arrow on the correct header cell on load', () => {
    const headerCell = fixture.nativeElement.querySelector('table th:nth-child(2) i');

    expect(headerCell).toBeTruthy();
  });

  xit('should display a sort arrow on the correct header cell on hover', () => {
    const event = new MouseEvent('mouseenter', {
      view: window,
      bubbles: true,
      cancelable: true,
    });
    const headerCell = fixture.nativeElement.querySelector(
      'table th:first-child'
    );
    headerCell.dispatchEvent(event);
    expect(fixture.nativeElement.querySelector('table th:nth-child(3) i')).toBeTruthy();
  });

  xit('should change sortDirection on click', () => {
    spyOn(component, 'handlePageChange');
    const headerCell = fixture.nativeElement.querySelector('table th:nth-child(2) i');

    headerCell.click();

    expect(component.handlePageChange).toHaveBeenCalledWith({
      page: 2,
      pageSize: PageSizes.TwentyFive,
      sortBy: 'foo',
      sortDirection: 'asc',
    });
  });

  it('should display ... on pager correctly', () => {
    component.page = 4;
    expect(fixture.nativeElement.querySelectorAll('.pagination .first-page-button > span').length).toEqual(1);

    component.page = 5;
    fixture.detectChanges();
    expect(fixture.nativeElement.querySelectorAll('.pagination .first-page-button > span').length).toEqual(2);

    component.page = 6;
    fixture.detectChanges();
    expect(fixture.nativeElement.querySelectorAll('.pagination .first-page-button > span').length).toEqual(1);
  });
});