# Usage

## Template Example

```
<bre-table
	[data]="data"
	[showLoadingIndicator]="isLoading"
	(onRowClick)="handleRowClick($event)"
	[itemCount]="totalItemCount"
    [checkBoxEnabled]="true"
    [clearSelection]="isSelectionCleared"
    (onSelectChange)="updateSelectedReviews($event)"
	(onPageChange)="handlePageChange($event)"
	[(currentPage)]="currentPage"
	[(currentPageSize)]="currentPageSize"
	[(sortBy)]="sortBy"
	[(sortDirection)]="sortDirection">
        <bre-table-column sortable="false"
          checkBox="true">
        </bre-table-column>
        <bre-table-column
            name="sort-col"
            label="Sortable Column"
            sortable="true"
            let-item>
                <ng-template>
                    <!--do something with item -->
                    {{item.prop1}}
                </ng-template>
        </bre-table-column>
        <bre-table-column
            name="fooCol"
            label="Another Column"
            let-item>
                <ng-template>
                    <some-component [prop]="item"></some-component>
                </ng-template>
		</bre-table-column>
</bre-datatable>
```

## Table Properties

_data:_ array of objects; each object represents a row in the table  
_showLoadingIndicator:_ boolean; indicates whether the table loading indicator should be shown or now  
_onRowClick:_ function; event handler to be called when a row is clicked  
_itemCount:_ number; total number of objects across all pages  
_checkBoxEnabled:_ boolean; indicates whether the table will have check boxes
_clearSelection:_ boolean; able to clear checkboxes from parent component
_onSelectChange:_ function; event handler to be called when checkbox selection occurs
_onPageChange:_ function; event handler to be called when paging or sorting occurs  
_currentPage:_ number; current page of rows that is being shown  
_currentPageSize:_ number; amount of rows to show per page  
_sortBy:_ string; name of the column to sort by  
_sortDirection:_ TableSortDirection; direction to sort in asc|desc

## Column Properties

_name:_ string; unique identifier for the column  
_label:_ string; the label/header of the column  
_sortable:_ boolean; indicates whether the rows can be sorted by the column or not
_checkBox_: boolean; indicates whether the rows will have checkboxes
_filterable_: boolean; indicates whether the column will be filterable with a variety of different filter types acessible through a single button
_searchable_: boolean; indicates whether the column can be searched with the autocomplete filter.

# More Information

The table component is built on top of [angular cdk](https://material.angular.io/cdk/table/overview).
