import { Component, EventEmitter, Input, Output } from '@angular/core';
import { SelectedRestaurantsDialogComponent } from '../selected-restaurants-dialog/selected-restaurants-dialog.component';
import { DialogService } from "../../services/dialog/dialog.service";

@Component({
  selector: 'bre-store-selection-type',
  templateUrl: './store-selection-type.component.html',
  styleUrls: ['./store-selection-type.component.scss']
})
export class StoreSelectionTypeComponent  {
  storeSelectionType: string;
  editMode: boolean = false;
  @Input() storesHierarchy;
  @Output() nextStepAction = new EventEmitter();
  @Output() reselectStoresVal = new EventEmitter();
  @Input() selectAllRestaurantsText: String = 'Proceed with deploying to all selected restaurants.';
  @Input() selectAllRestaurantsSubText: String = `This allows you to proceed with deployment to restaurants in the above selected region(s) or
  co-op(s).`;
  constructor(private dialog: DialogService) { }

    /**
   * Sets selection type for stores
   * @param type string, 'all' or 'specific'
   */
    setStoreSelectionType(type: string) {
      this.storeSelectionType = type;
      // Set next step as intermediate if user selects to deploy on specific stores, else final.
      const nextStep =
        this.storeSelectionType === "all" ? "last" : "intermediate";
      this.nextStepAction.emit(nextStep);
      if (this.editMode && type === "all") {
        this.reselectStoresVal.emit(true);
      }
    }

      /**
   * Shows dialog with selected stores
   */
  showAllStoresDialog() {
    this.dialog.open(SelectedRestaurantsDialogComponent, {
      storesHierarchy: this.storesHierarchy
    });
  }

}
